/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math3.ml.clustering.evaluation;

import java.util.List;
import oadd.org.apache.commons.math3.ml.clustering.Cluster;
import oadd.org.apache.commons.math3.ml.clustering.Clusterable;
import oadd.org.apache.commons.math3.ml.clustering.evaluation.ClusterEvaluator;
import oadd.org.apache.commons.math3.ml.distance.DistanceMeasure;
import oadd.org.apache.commons.math3.stat.descriptive.moment.Variance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumOfClusterVariances<T extends Clusterable>
extends ClusterEvaluator<T> {
    public SumOfClusterVariances(DistanceMeasure measure) {
        super(measure);
    }

    @Override
    public double score(List<? extends Cluster<T>> clusters) {
        double varianceSum = 0.0;
        for (Cluster<T> cluster : clusters) {
            if (cluster.getPoints().isEmpty()) continue;
            Clusterable center = this.centroidOf(cluster);
            Variance stat = new Variance();
            for (Clusterable point : cluster.getPoints()) {
                stat.increment(this.distance(point, center));
            }
            varianceSum += stat.getResult();
        }
        return varianceSum;
    }
}

