/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.analysis.integration;

import oadd.org.apache.commons.math.FunctionEvaluationException;
import oadd.org.apache.commons.math.MathRuntimeException;
import oadd.org.apache.commons.math.MaxIterationsExceededException;
import oadd.org.apache.commons.math.analysis.UnivariateRealFunction;
import oadd.org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import oadd.org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.util.FastMath;

public class RombergIntegrator
extends UnivariateRealIntegratorImpl {
    @Deprecated
    public RombergIntegrator(UnivariateRealFunction f) {
        super(f, 32);
    }

    public RombergIntegrator() {
        super(32);
    }

    @Deprecated
    public double integrate(double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min2, max);
    }

    public double integrate(UnivariateRealFunction f, double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        int m4 = this.maximalIterationCount + 1;
        double[] previousRow = new double[m4];
        double[] currentRow = new double[m4];
        this.clearResult();
        this.verifyInterval(min2, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        currentRow[0] = qtrap.stage(f, min2, max, 0);
        double olds = currentRow[0];
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double rLimit;
            double delta;
            double[] tmpRow = previousRow;
            previousRow = currentRow;
            currentRow = tmpRow;
            currentRow[0] = qtrap.stage(f, min2, max, i);
            for (int j = 1; j <= i; ++j) {
                double r = (1L << 2 * j) - 1L;
                double tIJm1 = currentRow[j - 1];
                currentRow[j] = tIJm1 + (tIJm1 - previousRow[j - 1]) / r;
            }
            double s2 = currentRow[i];
            if (i >= this.minimalIterationCount && ((delta = FastMath.abs(s2 - olds)) <= (rLimit = this.relativeAccuracy * (FastMath.abs(olds) + FastMath.abs(s2)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(s2, i);
                return this.result;
            }
            olds = s2;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 32) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ITERATIONS_LIMITS, 0, 32);
        }
    }
}

