/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.remote;

import java.io.File;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import oadd.org.apache.calcite.avatica.remote.ClientKeytabJaasConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosConnection {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosConnection.class);
    private static final String IBM_KRB5_LOGIN_MODULE = "com.ibm.security.auth.module.Krb5LoginModule";
    private static final String SUN_KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String JAAS_CONF_NAME = "AvaticaKeytabConf";
    private static final String RENEWAL_THREAD_NAME = "Avatica Kerberos Renewal Thread";
    private static final String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
    private static final boolean IS_IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM");
    public static final float PERCENT_OF_LIFETIME_TO_RENEW = 0.8f;
    public static final long RENEWAL_PERIOD = 30L;
    private final String principal;
    private final Configuration jaasConf;
    private Subject subject;
    private RenewalTask renewalTask;
    private Thread renewalThread;

    public KerberosConnection(String principal, File keytab) {
        this.principal = Objects.requireNonNull(principal);
        this.jaasConf = new ClientKeytabJaasConf(principal, Objects.requireNonNull(keytab).getAbsolutePath());
    }

    public synchronized Subject getSubject() {
        return this.subject;
    }

    public synchronized void login() {
        Map.Entry<LoginContext, Subject> securityMaterial = this.performKerberosLogin();
        this.subject = securityMaterial.getValue();
        Map.Entry<RenewalTask, Thread> renewalMaterial = this.createRenewalThread(securityMaterial.getKey(), this.subject, 30L);
        this.renewalTask = renewalMaterial.getKey();
        this.renewalThread = renewalMaterial.getValue();
        this.renewalThread.start();
    }

    Map.Entry<LoginContext, Subject> performKerberosLogin() {
        HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
        principals.add(new KerberosPrincipal(this.principal));
        Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
        try {
            return this.login(null, this.jaasConf, subject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to perform Kerberos login");
        }
    }

    Map.Entry<LoginContext, Subject> login(LoginContext prevContext, Configuration conf, Subject subject) throws LoginException {
        if (null != prevContext) {
            prevContext.logout();
        }
        LoginContext loginContext = this.createLoginContext(conf);
        loginContext.login();
        Subject loggedInSubject = loginContext.getSubject();
        if (null == loggedInSubject) {
            throw new RuntimeException("Failed to perform Kerberos login");
        }
        return new AbstractMap.SimpleEntry<LoginContext, Subject>(loginContext, loggedInSubject);
    }

    LoginContext createLoginContext(Configuration conf) throws LoginException {
        return new LoginContext(JAAS_CONF_NAME, this.subject, null, conf);
    }

    Map.Entry<RenewalTask, Thread> createRenewalThread(LoginContext originalContext, Subject originalSubject, long renewalPeriod) {
        RenewalTask task = new RenewalTask(this, originalContext, originalSubject, this.jaasConf, renewalPeriod);
        Thread t2 = new Thread(task);
        t2.setDaemon(true);
        t2.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t2, Throwable e) {
                LOG.error("Uncaught exception from Kerberos credential renewal thread", e);
            }
        });
        t2.setName(RENEWAL_THREAD_NAME);
        return new AbstractMap.SimpleEntry<RenewalTask, Thread>(task, t2);
    }

    public void stopRenewalThread() {
        if (null != this.renewalTask && null != this.renewalThread) {
            LOG.debug("Informing RenewalTask to gracefully stop and interrupting the renewal thread.");
            this.renewalTask.asyncStop();
            long now = System.currentTimeMillis();
            long until = now + 5000L;
            while (now < until && this.renewalThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                now = System.currentTimeMillis();
            }
            if (this.renewalThread.isAlive()) {
                LOG.warn("Renewal thread failed to gracefully stop, interrupting it");
                this.renewalThread.interrupt();
                try {
                    this.renewalThread.join(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.renewalThread.isAlive()) {
                LOG.warn("Renewal thread failed to gracefully and ungracefully stop, proceeding.");
            }
            this.renewalTask = null;
            this.renewalThread = null;
        } else {
            LOG.warn("Renewal thread was never started or already stopped.");
        }
    }

    static boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }

    public static boolean isIbmJava() {
        return IS_IBM_JAVA;
    }

    public static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? IBM_KRB5_LOGIN_MODULE : SUN_KRB5_LOGIN_MODULE;
    }

    static class RenewalTask
    implements Runnable {
        private static final Logger RENEWAL_LOG = LoggerFactory.getLogger(RenewalTask.class);
        private LoginContext context;
        private Subject subject;
        private final KerberosConnection utilInstance;
        private final Configuration conf;
        private final long renewalPeriod;
        private final AtomicBoolean keepRunning = new AtomicBoolean(true);

        RenewalTask(KerberosConnection utilInstance, LoginContext context, Subject subject, Configuration conf, long renewalPeriod) {
            this.utilInstance = Objects.requireNonNull(utilInstance);
            this.context = Objects.requireNonNull(context);
            this.subject = Objects.requireNonNull(subject);
            this.conf = Objects.requireNonNull(conf);
            this.renewalPeriod = renewalPeriod;
        }

        @Override
        public void run() {
            while (this.keepRunning.get() && !Thread.currentThread().isInterrupted()) {
                RENEWAL_LOG.debug("Checking if Kerberos ticket should be renewed");
                long now = System.currentTimeMillis();
                Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
                KerberosTicket activeTicket = null;
                for (KerberosTicket ticket : tickets) {
                    if (!KerberosConnection.isTGSPrincipal(ticket.getServer())) continue;
                    activeTicket = ticket;
                    break;
                }
                if (null == activeTicket) {
                    RENEWAL_LOG.debug("There is no active Kerberos ticket, renewing now");
                    this.renew();
                    continue;
                }
                if (this.shouldRenew(activeTicket.getStartTime().getTime(), activeTicket.getEndTime().getTime(), now)) {
                    RENEWAL_LOG.debug("The current ticket should be renewed now");
                    this.renew();
                }
                this.waitForNextCheck(this.renewalPeriod);
            }
        }

        boolean shouldRenew(long start, long end, long now) {
            long lifetime = end - start;
            long renewAfter = start + (long)((float)lifetime * 0.8f);
            return now >= renewAfter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renew() {
            try {
                KerberosConnection kerberosConnection = this.utilInstance;
                synchronized (kerberosConnection) {
                    Map.Entry<LoginContext, Subject> pair = this.utilInstance.login(this.context, this.conf, this.subject);
                    this.context = pair.getKey();
                    this.subject = pair.getValue();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to perform kerberos login");
            }
        }

        void waitForNextCheck(long renewalPeriod) {
            try {
                Thread.sleep(renewalPeriod);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        void asyncStop() {
            this.keepRunning.set(false);
        }
    }
}

