/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.buffer;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import oadd.com.codahale.metrics.Gauge;
import oadd.com.codahale.metrics.Histogram;
import oadd.com.codahale.metrics.Metric;
import oadd.com.codahale.metrics.MetricFilter;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DuplicatedByteBuf;
import oadd.io.netty.buffer.LargeBuffer;
import oadd.io.netty.buffer.PoolArena;
import oadd.io.netty.buffer.PoolThreadCache;
import oadd.io.netty.buffer.PooledByteBuf;
import oadd.io.netty.buffer.PooledByteBufAllocator;
import oadd.io.netty.buffer.PooledUnsafeDirectByteBuf;
import oadd.io.netty.buffer.Unpooled;
import oadd.io.netty.buffer.UnpooledByteBufAllocator;
import oadd.io.netty.buffer.UnsafeDirectLittleEndian;
import oadd.io.netty.util.internal.StringUtil;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledByteBufAllocatorL {
    private static final Logger memoryLogger = LoggerFactory.getLogger("drill.allocator");
    private static final int MEMORY_LOGGER_FREQUENCY_SECONDS = 60;
    public static final String METRIC_PREFIX = "drill.allocator.";
    private final MetricRegistry registry;
    private final AtomicLong hugeBufferSize = new AtomicLong(0L);
    private final AtomicLong hugeBufferCount = new AtomicLong(0L);
    private final AtomicLong normalBufferSize = new AtomicLong(0L);
    private final AtomicLong normalBufferCount = new AtomicLong(0L);
    private final InnerAllocator allocator;
    public final UnsafeDirectLittleEndian empty;
    public static final boolean ASSERT_ENABLED;

    public PooledByteBufAllocatorL(MetricRegistry registry) {
        this.registry = registry;
        this.allocator = new InnerAllocator();
        this.empty = new UnsafeDirectLittleEndian(new DuplicatedByteBuf(Unpooled.EMPTY_BUFFER));
    }

    public UnsafeDirectLittleEndian allocate(int size) {
        try {
            return this.allocator.directBuffer(size, Integer.MAX_VALUE);
        }
        catch (OutOfMemoryError e) {
            throw new OutOfMemoryException("Failure allocating buffer.", e);
        }
    }

    public ByteBuf allocateHeap(int initialCapacity, int maxCapacity) {
        try {
            return this.allocator.heapBuffer(initialCapacity, maxCapacity);
        }
        catch (OutOfMemoryError e) {
            throw new OutOfMemoryException("Failure allocating heap buffer.", e);
        }
    }

    public int getChunkSize() {
        return this.allocator.chunkSize;
    }

    static {
        boolean isAssertEnabled = false;
        if (!$assertionsDisabled) {
            isAssertEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ENABLED = isAssertEnabled;
    }

    private class InnerAllocator
    extends PooledByteBufAllocator {
        private final PoolArena<ByteBuffer>[] directArenas;
        private final MemoryStatusThread statusThread;
        private final Histogram largeBuffersHist;
        private final Histogram normalBuffersHist;
        private final int chunkSize;

        public InnerAllocator() {
            super(true, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), (int)Integer.getInteger("oadd.io.netty.allocator.maxOrder", 11), PooledByteBufAllocator.defaultSmallCacheSize(), PooledByteBufAllocator.defaultNormalCacheSize(), Boolean.parseBoolean(System.getProperty("oadd.io.netty.allocator.useCacheForAllThreads", "true")));
            try {
                Field f = PooledByteBufAllocator.class.getDeclaredField("directArenas");
                f.setAccessible(true);
                this.directArenas = (PoolArena[])f.get(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure while initializing allocator.  Unable to retrieve direct arenas field.", e);
            }
            this.chunkSize = this.directArenas[0].chunkSize;
            if (memoryLogger.isTraceEnabled()) {
                this.statusThread = new MemoryStatusThread();
                this.statusThread.start();
            } else {
                this.statusThread = null;
            }
            this.removeOldMetrics();
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.normal.size", new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return PooledByteBufAllocatorL.this.normalBufferSize.get();
                }
            });
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.normal.count", new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return PooledByteBufAllocatorL.this.normalBufferCount.get();
                }
            });
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.huge.size", new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return PooledByteBufAllocatorL.this.hugeBufferSize.get();
                }
            });
            PooledByteBufAllocatorL.this.registry.register("drill.allocator.huge.count", new Gauge<Long>(){

                @Override
                public Long getValue() {
                    return PooledByteBufAllocatorL.this.hugeBufferCount.get();
                }
            });
            this.largeBuffersHist = PooledByteBufAllocatorL.this.registry.histogram("drill.allocator.huge.hist");
            this.normalBuffersHist = PooledByteBufAllocatorL.this.registry.histogram("drill.allocator.normal.hist");
        }

        private synchronized void removeOldMetrics() {
            PooledByteBufAllocatorL.this.registry.removeMatching(new MetricFilter(){

                @Override
                public boolean matches(String name, Metric metric) {
                    return name.startsWith(PooledByteBufAllocatorL.METRIC_PREFIX);
                }
            });
        }

        private UnsafeDirectLittleEndian newDirectBufferL(int initialCapacity, int maxCapacity) {
            PoolThreadCache cache = this.threadCache();
            PoolArena<ByteBuffer> directArena = cache.directArena;
            if (directArena != null) {
                if (initialCapacity > directArena.chunkSize) {
                    ByteBuf buf = UnpooledByteBufAllocator.DEFAULT.directBuffer(initialCapacity, maxCapacity);
                    PooledByteBufAllocatorL.this.hugeBufferCount.incrementAndGet();
                    PooledByteBufAllocatorL.this.hugeBufferSize.addAndGet(buf.capacity());
                    this.largeBuffersHist.update(buf.capacity());
                    return new UnsafeDirectLittleEndian(new LargeBuffer(buf, PooledByteBufAllocatorL.this.hugeBufferSize, PooledByteBufAllocatorL.this.hugeBufferCount));
                }
                PooledByteBuf<ByteBuffer> buf = directArena.allocate(cache, initialCapacity, maxCapacity);
                if (!(buf instanceof PooledUnsafeDirectByteBuf)) {
                    this.fail();
                }
                this.normalBuffersHist.update(((ByteBuf)buf).capacity());
                if (ASSERT_ENABLED) {
                    PooledByteBufAllocatorL.this.normalBufferSize.addAndGet(((ByteBuf)buf).capacity());
                    PooledByteBufAllocatorL.this.normalBufferCount.incrementAndGet();
                }
                return new UnsafeDirectLittleEndian((PooledUnsafeDirectByteBuf)buf, PooledByteBufAllocatorL.this.normalBufferCount, PooledByteBufAllocatorL.this.normalBufferSize);
            }
            throw this.fail();
        }

        private UnsupportedOperationException fail() {
            return new UnsupportedOperationException("Drill requires that the JVM used supports access sun.misc.Unsafe.  This platform doesn't provide that functionality.");
        }

        @Override
        public UnsafeDirectLittleEndian directBuffer(int initialCapacity, int maxCapacity) {
            if (initialCapacity == 0 && maxCapacity == 0) {
                this.newDirectBuffer(initialCapacity, maxCapacity);
            }
            this.validate(initialCapacity, maxCapacity);
            return this.newDirectBufferL(initialCapacity, maxCapacity);
        }

        private void validate(int initialCapacity, int maxCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: 0+)");
            }
            if (initialCapacity > maxCapacity) {
                throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", initialCapacity, maxCapacity));
            }
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.directArenas.length);
            buf.append(" direct arena(s):");
            buf.append(StringUtil.NEWLINE);
            for (PoolArena<ByteBuffer> a : this.directArenas) {
                buf.append(a);
            }
            buf.append("Large buffers outstanding: ");
            buf.append(PooledByteBufAllocatorL.this.hugeBufferCount.get());
            buf.append(" totaling ");
            buf.append(PooledByteBufAllocatorL.this.hugeBufferSize.get());
            buf.append(" bytes.");
            buf.append('\n');
            buf.append("Normal buffers outstanding: ");
            buf.append(PooledByteBufAllocatorL.this.normalBufferCount.get());
            buf.append(" totaling ");
            buf.append(PooledByteBufAllocatorL.this.normalBufferSize.get());
            buf.append(" bytes.");
            return buf.toString();
        }

        private class MemoryStatusThread
        extends Thread {
            public MemoryStatusThread() {
                super("memory-status-logger");
                this.setDaemon(true);
                this.setName("allocation.logger");
            }

            @Override
            public void run() {
                while (true) {
                    memoryLogger.trace("Memory Usage: \n{}", (Object)PooledByteBufAllocatorL.this.toString());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }
}

