/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.crypto;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import oadd.io.jsonwebtoken.SignatureAlgorithm;
import oadd.io.jsonwebtoken.impl.crypto.EllipticCurveProvider;
import oadd.io.jsonwebtoken.impl.crypto.SignatureValidator;
import oadd.io.jsonwebtoken.lang.Assert;

public class EllipticCurveSignatureValidator
extends EllipticCurveProvider
implements SignatureValidator {
    private static final String EC_PUBLIC_KEY_REQD_MSG = "Elliptic Curve signature validation requires an ECPublicKey instance.";

    public EllipticCurveSignatureValidator(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(key instanceof ECPublicKey, EC_PUBLIC_KEY_REQD_MSG);
    }

    @Override
    public boolean isValid(byte[] data, byte[] signature) {
        Signature sig = this.createSignatureInstance();
        PublicKey publicKey = (PublicKey)this.key;
        try {
            int expectedSize = EllipticCurveSignatureValidator.getSignatureByteArrayLength(this.alg);
            byte[] derSignature = expectedSize != signature.length && signature[0] == 48 ? signature : EllipticCurveProvider.transcodeSignatureToDER(signature);
            return this.doVerify(sig, publicKey, data, derSignature);
        }
        catch (Exception e) {
            String msg = "Unable to verify Elliptic Curve signature using configured ECPublicKey. " + e.getMessage();
            throw new oadd.io.jsonwebtoken.security.SignatureException(msg, e);
        }
    }

    protected boolean doVerify(Signature sig, PublicKey publicKey, byte[] data, byte[] signature) throws InvalidKeyException, SignatureException {
        sig.initVerify(publicKey);
        sig.update(data);
        return sig.verify(signature);
    }
}

