/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.ser;

import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import oadd.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import oadd.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongMethodPropertyWriter
extends OptimizedBeanPropertyWriter<LongMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final long _suppressableLong;
    private final boolean _suppressableLongSet;

    public LongMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableLongSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableLongSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new LongMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public LongMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new LongMethodPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.longGetter(bean, this._propertyIndex);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, false);
            return;
        }
        if (!this._suppressableLongSet || this._suppressableLong != value) {
            gen.writeFieldName(this._fastName);
            gen.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.longGetter(bean, this._propertyIndex);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, true);
            return;
        }
        if (!this._suppressableLongSet || this._suppressableLong != value) {
            gen.writeNumber(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

