/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.cert.CertPathBuilder;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.JsseUtils_7;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils_8
extends JsseUtils_7 {
    JsseUtils_8() {
    }

    static SNIMatcher exportSNIMatcher(BCSNIMatcher matcher) {
        if (null == matcher) {
            return null;
        }
        if (matcher instanceof ImportSNIMatcher) {
            return ((ImportSNIMatcher)matcher).unwrap();
        }
        return new ExportSNIMatcher(matcher);
    }

    static void addStatusResponses(CertPathBuilder pkixBuilder, PKIXBuilderParameters pkixParameters, Map<X509Certificate, byte[]> statusResponseMap) {
        if (statusResponseMap.isEmpty()) {
            return;
        }
        List<PKIXCertPathChecker> certPathCheckers = pkixParameters.getCertPathCheckers();
        PKIXRevocationChecker existingChecker = JsseUtils_8.getFirstRevocationChecker(certPathCheckers);
        if (null != existingChecker) {
            Map<X509Certificate, byte[]> ocspResponses = existingChecker.getOcspResponses();
            if (JsseUtils_8.putAnyAbsent(ocspResponses, statusResponseMap) > 0) {
                existingChecker.setOcspResponses(ocspResponses);
                pkixParameters.setCertPathCheckers(certPathCheckers);
            }
        } else if (pkixParameters.isRevocationEnabled()) {
            PKIXRevocationChecker checker = (PKIXRevocationChecker)pkixBuilder.getRevocationChecker();
            checker.setOcspResponses(statusResponseMap);
            pkixParameters.addCertPathChecker(checker);
        }
    }

    static List<SNIMatcher> exportSNIMatchers(Collection<BCSNIMatcher> matchers) {
        if (null == matchers || matchers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIMatcher> result = new ArrayList<SNIMatcher>(matchers.size());
        for (BCSNIMatcher matcher : matchers) {
            result.add(JsseUtils_8.exportSNIMatcher(matcher));
        }
        return Collections.unmodifiableList(result);
    }

    static Object exportSNIMatchersDynamic(Collection<BCSNIMatcher> matchers) {
        return JsseUtils_8.exportSNIMatchers(matchers);
    }

    static SNIServerName exportSNIServerName(BCSNIServerName serverName) {
        if (null == serverName) {
            return null;
        }
        int type = serverName.getType();
        byte[] encoded = serverName.getEncoded();
        switch (type) {
            case 0: {
                return new SNIHostName(encoded);
            }
        }
        return new UnknownServerName(type, encoded);
    }

    static List<SNIServerName> exportSNIServerNames(Collection<BCSNIServerName> serverNames) {
        if (null == serverNames || serverNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIServerName> result = new ArrayList<SNIServerName>(serverNames.size());
        for (BCSNIServerName serverName : serverNames) {
            result.add(JsseUtils_8.exportSNIServerName(serverName));
        }
        return Collections.unmodifiableList(result);
    }

    static Object exportSNIServerNamesDynamic(Collection<BCSNIServerName> serverNames) {
        return JsseUtils_8.exportSNIServerNames(serverNames);
    }

    static PKIXRevocationChecker getFirstRevocationChecker(List<PKIXCertPathChecker> certPathCheckers) {
        for (PKIXCertPathChecker certPathChecker : certPathCheckers) {
            if (!(certPathChecker instanceof PKIXRevocationChecker)) continue;
            return (PKIXRevocationChecker)certPathChecker;
        }
        return null;
    }

    static BCSNIMatcher importSNIMatcher(SNIMatcher matcher) {
        if (null == matcher) {
            return null;
        }
        if (matcher instanceof ExportSNIMatcher) {
            return ((ExportSNIMatcher)matcher).unwrap();
        }
        return new ImportSNIMatcher(matcher);
    }

    static List<BCSNIMatcher> importSNIMatchers(Collection<SNIMatcher> matchers) {
        if (null == matchers || matchers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIMatcher> result = new ArrayList<BCSNIMatcher>(matchers.size());
        for (SNIMatcher matcher : matchers) {
            result.add(JsseUtils_8.importSNIMatcher(matcher));
        }
        return Collections.unmodifiableList(result);
    }

    static List<BCSNIMatcher> importSNIMatchersDynamic(Object matchers) {
        return JsseUtils_8.importSNIMatchers((Collection)matchers);
    }

    static BCSNIServerName importSNIServerName(SNIServerName serverName) {
        if (null == serverName) {
            return null;
        }
        int type = serverName.getType();
        byte[] encoded = serverName.getEncoded();
        switch (type) {
            case 0: {
                return new BCSNIHostName(encoded);
            }
        }
        return new JsseUtils.BCUnknownServerName(type, encoded);
    }

    static List<BCSNIServerName> importSNIServerNames(Collection<SNIServerName> serverNames) {
        if (null == serverNames || serverNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> result = new ArrayList<BCSNIServerName>(serverNames.size());
        for (SNIServerName serverName : serverNames) {
            result.add(JsseUtils_8.importSNIServerName(serverName));
        }
        return Collections.unmodifiableList(result);
    }

    static List<BCSNIServerName> importSNIServerNamesDynamic(Object serverNames) {
        return JsseUtils_8.importSNIServerNames((Collection)serverNames);
    }

    static <K, V> int putAnyAbsent(Map<K, V> to, Map<K, V> from) {
        int count = 0;
        for (Map.Entry<K, V> entry : from.entrySet()) {
            if (null != to.putIfAbsent(entry.getKey(), entry.getValue())) continue;
            ++count;
        }
        return count;
    }

    static class ExportSNIMatcher
    extends SNIMatcher {
        private final BCSNIMatcher matcher;

        ExportSNIMatcher(BCSNIMatcher matcher) {
            super(matcher.getType());
            this.matcher = matcher;
        }

        public boolean matches(SNIServerName serverName) {
            return this.matcher.matches(JsseUtils_8.importSNIServerName(serverName));
        }

        BCSNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class ImportSNIMatcher
    extends BCSNIMatcher {
        private final SNIMatcher matcher;

        ImportSNIMatcher(SNIMatcher matcher) {
            super(matcher.getType());
            this.matcher = matcher;
        }

        public boolean matches(BCSNIServerName serverName) {
            return this.matcher.matches(JsseUtils_8.exportSNIServerName(serverName));
        }

        SNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int type, byte[] encoded) {
            super(type, encoded);
        }
    }
}

