/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util.filereader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Stopwatch;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.util.filereader.DirectBufInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedDirectBufInputStream
extends DirectBufInputStream
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(BufferedDirectBufInputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 0x800000;
    private static final int DEFAULT_TEMP_BUFFER_SIZE = 8192;
    private static final int SMALL_BUFFER_SIZE = 262144;
    protected volatile DrillBuf internalBuffer;
    protected int count;
    protected int curPosInBuffer;
    protected long curPosInStream;
    private int bufSize;
    private volatile DrillBuf tempBuffer;

    private DrillBuf getBuf() throws IOException {
        this.checkInputStreamState();
        if (this.internalBuffer == null) {
            throw new IOException("Input stream is closed.");
        }
        return this.internalBuffer;
    }

    public BufferedDirectBufInputStream(InputStream in, BufferAllocator allocator, String id, long startOffset, long totalByteSize, boolean enforceTotalByteSize, boolean enableHints) {
        this(in, allocator, id, startOffset, totalByteSize, 0x800000, enforceTotalByteSize, enableHints);
    }

    public BufferedDirectBufInputStream(InputStream in, BufferAllocator allocator, String id, long startOffset, long totalByteSize, int bufSize, boolean enforceTotalByteSize, boolean enableHints) {
        super(in, allocator, id, startOffset, totalByteSize, enforceTotalByteSize, enableHints);
        Preconditions.checkArgument(bufSize >= 0);
        int bSize = Math.min(bufSize, Math.toIntExact(totalByteSize));
        --bSize;
        bSize |= bSize >>> 1;
        bSize |= bSize >>> 2;
        bSize |= bSize >>> 4;
        bSize |= bSize >>> 8;
        bSize |= bSize >>> 16;
        this.bufSize = ++bSize;
    }

    @Override
    public void init() throws UnsupportedOperationException, IOException {
        super.init();
        this.internalBuffer = this.allocator.buffer(this.bufSize);
        this.tempBuffer = this.allocator.buffer(8192);
    }

    private DrillBuf reallocBuffer(int newSize) {
        this.internalBuffer.release();
        this.bufSize = newSize;
        this.internalBuffer = this.allocator.buffer(this.bufSize);
        logger.debug("Internal buffer resized to {}", (Object)newSize);
        return this.internalBuffer;
    }

    private int getNextBlock() throws IOException {
        Preconditions.checkState(this.curPosInBuffer >= this.count, "Internal error: Buffered stream has not been consumed and trying to read more from underlying stream");
        this.checkInputStreamState();
        DrillBuf buffer = this.getBuf();
        buffer.clear();
        this.curPosInBuffer = 0;
        this.count = 0;
        if (logger.isTraceEnabled()) {
            logger.trace("PERF: Disk read start. {}, StartOffset: {}, TotalByteSize: {}, BufferSize: {}, Count: {}, CurPosInStream: {}, CurPosInBuffer: {}", this.streamId, this.startOffset, this.totalByteSize, this.bufSize, this.count, this.curPosInStream, this.curPosInBuffer);
        }
        Stopwatch timer = Stopwatch.createStarted();
        int bytesToRead = 0;
        if (this.enforceTotalByteSize) {
            bytesToRead = (long)buffer.capacity() >= this.totalByteSize + this.startOffset - this.curPosInStream ? (int)(this.totalByteSize + this.startOffset - this.curPosInStream) : buffer.capacity();
        } else {
            if ((long)buffer.capacity() >= this.totalByteSize + this.startOffset - this.curPosInStream && buffer.capacity() > 262144) {
                buffer = this.reallocBuffer(262144);
            }
            bytesToRead = buffer.capacity();
        }
        ByteBuffer directBuffer = buffer.nioBuffer(this.curPosInBuffer, bytesToRead);
        int bytesRead = -1;
        int nBytes = 0;
        if (bytesToRead > 0) {
            try {
                nBytes = HadoopStreams.wrap((FSDataInputStream)this.getInputStream()).read(directBuffer);
            }
            catch (Exception e) {
                logger.error("Error reading from stream {}. Error was : {}", (Object)this.streamId, (Object)e.getMessage());
                throw new IOException(e);
            }
            if (nBytes > 0) {
                buffer.writerIndex(nBytes);
                this.count = nBytes + this.curPosInBuffer;
                this.curPosInStream = this.getInputStream().getPos();
                bytesRead = nBytes;
                if (logger.isTraceEnabled()) {
                    logger.trace("PERF: Disk read complete. {}, StartOffset: {}, TotalByteSize: {}, BufferSize: {}, BytesRead: {}, Count: {}, CurPosInStream: {}, CurPosInBuffer: {}, Time: {} ms", this.streamId, this.startOffset, this.totalByteSize, this.bufSize, bytesRead, this.count, this.curPosInStream, this.curPosInBuffer, (double)timer.elapsed(TimeUnit.MICROSECONDS) / 1000.0);
                }
            }
        }
        return this.count - this.curPosInBuffer;
    }

    private int readInternal(DrillBuf buf, int off, int len) throws IOException {
        int bytesRead;
        int bytesAvailable = this.count - this.curPosInBuffer;
        if (bytesAvailable <= 0 && (bytesRead = this.getNextBlock()) <= 0) {
            return -1;
        }
        bytesAvailable = this.count - this.curPosInBuffer;
        int copyBytes = Math.min(bytesAvailable, len);
        this.getBuf().getBytes(this.curPosInBuffer, buf, off, copyBytes);
        buf.writerIndex(off + copyBytes);
        this.curPosInBuffer += copyBytes;
        return copyBytes;
    }

    private DrillBuf readInternal(int off, int len) throws IOException {
        int bytesRead;
        int bytesAvailable = this.count - this.curPosInBuffer;
        if (bytesAvailable <= 0 && (bytesRead = this.getNextBlock()) <= 0) {
            return null;
        }
        bytesAvailable = this.count - this.curPosInBuffer;
        int bytesToRead = Math.min(bytesAvailable, len);
        DrillBuf newBuf = this.getBuf().slice(off, bytesToRead);
        newBuf.retain();
        return newBuf;
    }

    @Override
    public synchronized int read() throws IOException {
        int bytesRead;
        if (this.count - this.curPosInBuffer <= 0 && (bytesRead = this.getNextBlock()) <= 0) {
            return -1;
        }
        ++this.curPosInBuffer;
        return this.getBuf().nioBuffer().get() & 0xFF;
    }

    @Override
    public synchronized int read(DrillBuf buf, int off, int len) throws IOException {
        int nRead;
        this.checkInputStreamState();
        Preconditions.checkArgument(off >= 0 && len >= 0 && buf.capacity() >= off + len);
        int bytesRead = 0;
        do {
            int lenToRead;
            int readStart;
            if ((nRead = this.readInternal(buf, readStart = off + bytesRead, lenToRead = len - bytesRead)) > 0) continue;
            if (bytesRead == 0) {
                return -1;
            }
            return bytesRead;
        } while ((bytesRead += nRead) < len);
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return b.length == 1 ? this.read() : this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int nRead;
        this.checkInputStreamState();
        Preconditions.checkArgument(off >= 0 && len >= 0 && buf.length >= off + len);
        int bytesRead = 0;
        if (len == 0) {
            return 0;
        }
        DrillBuf byteBuf = len <= 8192 ? this.tempBuffer : this.allocator.buffer(len);
        do {
            int lenToRead;
            int readStart;
            if ((nRead = this.readInternal(byteBuf, readStart = off + bytesRead, lenToRead = len - bytesRead)) <= 0) {
                if (bytesRead == 0) {
                    return -1;
                }
                return bytesRead;
            }
            byteBuf.nioBuffer().get(buf, off + bytesRead, nRead);
            byteBuf.clear();
        } while ((bytesRead += nRead) < len);
        if (len > 8192) {
            byteBuf.release();
        }
        return bytesRead;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.checkInputStreamState();
        long bytesAvailable = this.count - this.curPosInBuffer;
        long bytesSkipped = 0L;
        if (n <= 0L) {
            return 0L;
        }
        if (bytesAvailable <= 0L) {
            this.checkInputStreamState();
            bytesAvailable = this.getNextBlock();
            if (bytesAvailable <= 0L) {
                return 0L;
            }
        }
        bytesSkipped = Math.min(bytesAvailable, n);
        this.curPosInBuffer += Math.toIntExact(bytesSkipped);
        return bytesSkipped;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkInputStreamState();
        int bytesAvailable = this.count - this.curPosInBuffer;
        int underlyingAvailable = this.getInputStream().available();
        int available = bytesAvailable + underlyingAvailable;
        if (available < 0) {
            return Integer.MAX_VALUE;
        }
        return available;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("Mark/reset is not supported.");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("Mark/reset is not supported.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long getPos() throws IOException {
        return (long)this.curPosInBuffer + this.startOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        BufferedDirectBufInputStream bufferedDirectBufInputStream = this;
        synchronized (bufferedDirectBufInputStream) {
            try {
                InputStream inp = this.in;
                if (inp != null) {
                    this.in = null;
                    inp.close();
                }
            }
            finally {
                DrillBuf buffer = this.internalBuffer;
                if (buffer != null) {
                    this.internalBuffer = null;
                    buffer.release();
                }
                if ((buffer = this.tempBuffer) != null) {
                    this.tempBuffer = null;
                    buffer.release();
                }
            }
        }
    }
}

