/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.common.KerberosUtil;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.metrics.DrillMetrics;
import oadd.org.apache.drill.exec.rpc.NamedThreadFactory;
import oadd.org.apache.drill.exec.rpc.TransportCheck;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorProvider;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorProviderImpl;
import oadd.org.apache.drill.exec.server.options.OptionDefinition;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapContext
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapContext.class);
    private static final int MIN_SCAN_THREADPOOL_SIZE = 4;
    private static final String customHostName = System.getenv("DRILL_HOST_NAME");
    private static final String processUserName = System.getProperty("user.name");
    private final DrillConfig config;
    private final CaseInsensitiveMap<OptionDefinition> definitions;
    private final AuthenticatorProvider authProvider;
    private final EventLoopGroup loop;
    private final EventLoopGroup loop2;
    private final MetricRegistry metrics;
    private final BufferAllocator allocator;
    private final ScanResult classpathScan;
    private final ExecutorService executor;
    private final ExecutorService scanExecutor;
    private final ExecutorService scanDecodeExecutor;
    private final String hostName;

    public BootStrapContext(DrillConfig config, CaseInsensitiveMap<OptionDefinition> definitions, ScanResult classpathScan) throws DrillbitStartupException {
        this.config = config;
        this.definitions = definitions;
        this.classpathScan = classpathScan;
        this.hostName = BootStrapContext.getCanonicalHostName();
        this.login(config);
        this.authProvider = new AuthenticatorProviderImpl(config, classpathScan);
        this.loop = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitServer-");
        this.loop2 = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitClient-");
        this.metrics = DrillMetrics.getRegistry();
        this.allocator = RootAllocatorFactory.newRoot(config);
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new NamedThreadFactory("drill-executor-")){

            @Override
            protected void afterExecute(Runnable r, Throwable t2) {
                if (t2 != null) {
                    logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t2);
                }
                super.afterExecute(r, t2);
            }
        };
        int numCores = Runtime.getRuntime().availableProcessors();
        int numScanThreads = (int)config.getDouble("drill.exec.scan.threadpool_size");
        int numScanDecodeThreads = (int)config.getDouble("drill.exec.scan.decode_threadpool_size");
        int scanThreadPoolSize = 4 > numScanThreads ? 4 : numScanThreads;
        int scanDecodeThreadPoolSize = (numCores + 1) / 2 > numScanDecodeThreads ? (numCores + 1) / 2 : numScanDecodeThreads;
        this.scanExecutor = Executors.newFixedThreadPool(scanThreadPoolSize, new NamedThreadFactory("scan-"));
        this.scanDecodeExecutor = Executors.newFixedThreadPool(scanDecodeThreadPoolSize, new NamedThreadFactory("scan-decode-"));
    }

    private void login(DrillConfig config) throws DrillbitStartupException {
        try {
            if (config.hasPath("drill.exec.security.auth.principal")) {
                Configuration loginConf = new Configuration();
                loginConf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
                if (config.hasPath("drill.exec.security.auth.auth_to_local")) {
                    loginConf.set("hadoop.security.auth_to_local", config.getString("drill.exec.security.auth.auth_to_local"));
                }
                UserGroupInformation.setConfiguration((Configuration)loginConf);
                String principal = config.getString("drill.exec.security.auth.principal");
                String[] parts = KerberosUtil.splitPrincipalIntoParts(principal);
                if (parts.length != 3) {
                    throw new DrillbitStartupException(String.format("Invalid %s, Drill service principal must be of format 'primary/instance@REALM' or 'primary@REALM'", "drill.exec.security.auth.principal"));
                }
                parts[1] = "".equals(parts[1]) ? "" : KerberosUtil.canonicalizeInstanceName(parts[1], this.hostName);
                String canonicalizedPrincipal = KerberosUtil.getPrincipalFromParts(parts[0], parts[1], parts[2]);
                String keytab = config.getString("drill.exec.security.auth.keytab");
                UserGroupInformation.loginUserFromKeytab((String)canonicalizedPrincipal, (String)keytab);
                logger.info("Process user name: '{}' and logged in successfully as '{}'", (Object)processUserName, (Object)canonicalizedPrincipal);
            } else {
                UserGroupInformation.getLoginUser();
            }
        }
        catch (IOException e) {
            throw new DrillbitStartupException("Failed to login.", e);
        }
    }

    private static String getCanonicalHostName() throws DrillbitStartupException {
        try {
            return customHostName != null ? customHostName : InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new DrillbitStartupException("Could not get canonical hostname.", e);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService getScanExecutor() {
        return this.scanExecutor;
    }

    public ExecutorService getScanDecodeExecutor() {
        return this.scanDecodeExecutor;
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    public CaseInsensitiveMap<OptionDefinition> getDefinitions() {
        return this.definitions;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.loop;
    }

    public EventLoopGroup getBitClientLoopGroup() {
        return this.loop2;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public ScanResult getClasspathScan() {
        return this.classpathScan;
    }

    public AuthenticatorProvider getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public void close() {
        try {
            DrillMetrics.resetMetrics();
        }
        catch (Error | Exception e) {
            logger.warn("failure resetting metrics.", e);
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                logger.warn("Executor interrupted while awaiting termination");
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.scanExecutor != null) {
            this.scanExecutor.shutdown();
        }
        if (this.scanDecodeExecutor != null) {
            this.scanDecodeExecutor.shutdownNow();
        }
        try {
            AutoCloseables.close(this.allocator, this.authProvider);
            BootStrapContext.shutdown(this.loop);
            BootStrapContext.shutdown(this.loop2);
        }
        catch (Exception e) {
            logger.error("Error while closing", e);
        }
    }

    private static void shutdown(EventLoopGroup loopGroup) {
        if (loopGroup != null && !loopGroup.isShutdown() && !loopGroup.isShuttingDown()) {
            try {
                loopGroup.shutdownGracefully();
            }
            catch (Exception e) {
                logger.error("Error while closing", e);
            }
        }
    }
}

