/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.org.apache.http.impl.client;

import oadd.org.apache.calcite.avatica.org.apache.http.HeaderElement;
import oadd.org.apache.calcite.avatica.org.apache.http.HttpResponse;
import oadd.org.apache.calcite.avatica.org.apache.http.annotation.Contract;
import oadd.org.apache.calcite.avatica.org.apache.http.annotation.ThreadingBehavior;
import oadd.org.apache.calcite.avatica.org.apache.http.conn.ConnectionKeepAliveStrategy;
import oadd.org.apache.calcite.avatica.org.apache.http.message.BasicHeaderElementIterator;
import oadd.org.apache.calcite.avatica.org.apache.http.protocol.HttpContext;
import oadd.org.apache.calcite.avatica.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

