/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.io.File;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.AvaticaFactory;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.NoSuchStatementException;
import oadd.org.apache.calcite.avatica.QueryState;
import oadd.org.apache.calcite.avatica.UnregisteredDriver;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.client.DrillClient;
import oadd.org.apache.drill.exec.client.InvalidConnectionInfoException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.memory.RootAllocatorFactory;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.server.Drillbit;
import oadd.org.apache.drill.exec.server.RemoteServiceSet;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.util.StoragePluginTestUtils;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.DrillConnection;
import org.apache.drill.jdbc.DrillConnectionConfig;
import org.apache.drill.jdbc.InvalidParameterSqlException;
import org.apache.drill.jdbc.JdbcApiSqlException;
import org.apache.drill.jdbc.impl.DrillStatementImpl;
import org.apache.drill.jdbc.impl.DrillStatementRegistry;
import org.apache.drill.jdbc.impl.DriverImpl;
import org.apache.drill.jdbc.impl.GlobalServiceSetReference;
import org.apache.drill.shaded.guava.com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillConnectionImpl
extends AvaticaConnection
implements DrillConnection {
    private static final Logger logger = LoggerFactory.getLogger(DrillConnection.class);
    final DrillStatementRegistry openStatementsRegistry = new DrillStatementRegistry();
    final DrillConnectionConfig config;
    private final DrillClient client;
    private final BufferAllocator allocator;
    private Drillbit bit;
    private RemoteServiceSet serviceSet;

    public DrillConnectionImpl(DriverImpl driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        super(driver, factory, url, info);
        super.setTransactionIsolation(0);
        super.setAutoCommit(true);
        super.setReadOnly(false);
        this.config = new DrillConnectionConfig(info);
        try {
            try {
                String connect = null;
                if (this.config.isLocal()) {
                    try {
                        Class.forName("org.eclipse.jetty.server.Handler");
                    }
                    catch (ClassNotFoundException e) {
                        throw new SQLNonTransientConnectionException("Running Drill in embedded mode using Drill's jdbc-all JDBC driver Jar file alone is not supported.", e);
                    }
                    DrillConfig dConfig = DrillConfig.create(info);
                    this.allocator = RootAllocatorFactory.newRoot(dConfig);
                    RemoteServiceSet set = GlobalServiceSetReference.SETS.get();
                    if (set == null) {
                        set = this.serviceSet = RemoteServiceSet.getLocalServiceSet();
                        try {
                            this.bit = new Drillbit(dConfig, this.serviceSet);
                            this.bit.run();
                        }
                        catch (UserException e) {
                            throw new SQLException("Failure in starting embedded Drillbit: " + e.getMessage(), e);
                        }
                        catch (Exception e) {
                            throw new SQLException("Failure in starting embedded Drillbit: " + e, e);
                        }
                    } else {
                        this.serviceSet = null;
                        this.bit = null;
                    }
                    DrillConnectionImpl.makeTmpSchemaLocationsUnique(this.bit.getContext().getStorage(), info);
                    this.client = new DrillClient(dConfig, set.getCoordinator());
                } else if (this.config.isDirect()) {
                    DrillConfig dConfig = DrillConfig.forClient();
                    this.allocator = RootAllocatorFactory.newRoot(dConfig);
                    this.client = new DrillClient(dConfig, true);
                    connect = this.config.getZookeeperConnectionString();
                } else {
                    DrillConfig dConfig = DrillConfig.forClient();
                    this.allocator = RootAllocatorFactory.newRoot(dConfig);
                    this.client = new DrillClient();
                    connect = this.config.getZookeeperConnectionString();
                }
                this.client.setClientName("Apache Drill JDBC Driver");
                this.client.connect(connect, info);
            }
            catch (OutOfMemoryException e) {
                throw new SQLNonTransientConnectionException("Failure creating root allocator", e);
            }
            catch (InvalidConnectionInfoException e) {
                throw new SQLNonTransientConnectionException("Invalid parameter in connection string: " + e.getMessage(), e);
            }
            catch (RpcException e) {
                throw new SQLNonTransientConnectionException("Failure in connecting to Drill: " + e, e);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Failure in creating DrillConnectionImpl: " + e, e);
            }
        }
        catch (Throwable t2) {
            this.close();
            throw t2;
        }
    }

    @Override
    protected ResultSet createResultSet(Meta.MetaResultSet metaResultSet, QueryState state) throws SQLException {
        return super.createResultSet(metaResultSet, state);
    }

    @Override
    protected Meta.ExecuteResult prepareAndExecuteInternal(AvaticaStatement statement, String sql, long maxRowCount) throws SQLException, NoSuchStatementException {
        try {
            return super.prepareAndExecuteInternal(statement, sql, maxRowCount);
        }
        catch (RuntimeException e) {
            Throwables.throwIfInstanceOf(e.getCause(), SQLException.class);
            throw e;
        }
    }

    @Override
    protected void checkOpen() throws AlreadyClosedSqlException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Connection is already closed.");
        }
    }

    @Override
    public DrillConnectionConfig getConfig() {
        return this.config;
    }

    BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public DrillClient getClient() {
        return this.client;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Can't turn off auto-committing; transactions are not supported.  (Drill is not transactional.)");
        }
        assert (this.getAutoCommit()) : "getAutoCommit() = " + this.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call commit() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.commit() is not supported.  (Drill is not transactional.)");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call rollback() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.rollback() is not supported.  (Drill is not transactional.)");
    }

    @Override
    public boolean isClosed() {
        try {
            if (super.isClosed()) {
                return true;
            }
            return this.client != null ? !this.client.connectionIsActive() : false;
        }
        catch (SQLException e) {
            throw new DrillRuntimeException("Unexpected exception from " + this.getClass().getSuperclass() + ".isClosed(): " + e, e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported. (Drill is not transactional.)");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported. (Drill is not transactional.)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported. (Drill is not transactional.)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported. (Drill is not transactional.)");
    }

    private String isolationValueToString(int level) {
        switch (level) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "<Unknown transaction isolation level value " + level + ">";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new SQLFeatureNotSupportedException("Can't change transaction isolation level to Connection." + this.isolationValueToString(level) + " (from Connection." + this.isolationValueToString(this.getTransactionIsolation()) + "). (Drill is not transactional.)");
            }
            default: {
                throw new JdbcApiSqlException("Invalid transaction isolation level value " + level);
            }
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws JdbcApiSqlException, SQLFeatureNotSupportedException {
        this.checkOpen();
        if (null == executor) {
            throw new InvalidParameterSqlException("Invalid (null) \"executor\" parameter to setNetworkTimeout(...)");
        }
        if (milliseconds < 0) {
            throw new InvalidParameterSqlException("Invalid (negative) \"milliseconds\" parameter to setNetworkTimeout(...) (" + milliseconds + ")");
        }
        if (0 != milliseconds) {
            throw new SQLFeatureNotSupportedException("Setting network timeout is not supported.");
        }
    }

    @Override
    public int getNetworkTimeout() throws AlreadyClosedSqlException {
        this.checkOpen();
        return 0;
    }

    @Override
    public DrillStatementImpl createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return (DrillStatementImpl)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        try {
            return super.prepareCall(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        try {
            return super.nativeSQL(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            return super.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        try {
            return super.getTypeMap();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        try {
            super.setTypeMap(map);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            return super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return super.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return super.prepareStatement(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return super.prepareStatement(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        try {
            return super.createClob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        try {
            return super.createBlob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        try {
            return super.createNClob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        try {
            return super.createSQLXML();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException(String.format("Invalid timeout (%d<0).", timeout));
        }
        return !this.isClosed() && this.client.hasPing(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkOpen();
        }
        catch (AlreadyClosedSqlException e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        try {
            super.setClientInfo(name, value);
        }
        catch (UnsupportedOperationException e) {
            SQLFeatureNotSupportedException intended = new SQLFeatureNotSupportedException(e.getMessage(), e);
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)intended);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkOpen();
        }
        catch (AlreadyClosedSqlException e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        try {
            super.setClientInfo(properties);
        }
        catch (UnsupportedOperationException e) {
            SQLFeatureNotSupportedException intended = new SQLFeatureNotSupportedException(e.getMessage(), e);
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)intended);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkOpen();
        try {
            return super.createStruct(typeName, attributes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        try {
            this.client.runQuery(UserBitShared.QueryType.SQL, String.format("use %s", schema));
        }
        catch (RpcException e) {
            throw new SQLException("Error when setting schema", e);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        try {
            UserProtos.GetServerMetaResp response = (UserProtos.GetServerMetaResp)this.client.getServerMeta().get();
            if (response.getStatus() != UserProtos.RequestStatus.OK) {
                UserBitShared.DrillPBError drillError = response.getError();
                throw new SQLException("Error when getting server meta: " + drillError.getMessage());
            }
            UserProtos.ServerMeta serverMeta = response.getServerMeta();
            String currentSchema = serverMeta.hasCurrentSchema() ? serverMeta.getCurrentSchema() : null;
            return StringUtils.isEmpty(currentSchema) ? null : currentSchema;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SQLException("Error when getting server meta", e);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkOpen();
        try {
            super.abort(executor);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    private static void closeOrWarn(AutoCloseable autoCloseable, String message, Logger logger) {
        if (autoCloseable == null) {
            return;
        }
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            logger.warn(message, e);
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.openStatementsRegistry.close();
        DrillConnectionImpl.closeOrWarn(this.client, "Exception while closing client.", logger);
        DrillConnectionImpl.closeOrWarn(this.allocator, "Exception while closing allocator.", logger);
        if (this.bit != null) {
            this.bit.close();
        }
        DrillConnectionImpl.closeOrWarn(this.serviceSet, "Exception while closing service set.", logger);
    }

    private static void makeTmpSchemaLocationsUnique(StoragePluginRegistry pluginRegistry, Properties props) {
        try {
            if (props != null && "true".equalsIgnoreCase(props.getProperty("drillJDBCUnitTests"))) {
                String logMessage = "The {} property was not configured";
                String dfsTmpPath = props.getProperty("drillJDBCUnitTests.dfs.tmp");
                String dfsRootPath = props.getProperty("drillJDBCUnitTests.dfs.root");
                String dfsDefaultPath = props.getProperty("drillJDBCUnitTests.dfs.default");
                if (dfsTmpPath == null) {
                    logger.warn("The {} property was not configured", (Object)"drillJDBCUnitTests.dfs.tmp");
                } else {
                    StoragePluginTestUtils.updateSchemaLocation("dfs", pluginRegistry, new File(dfsTmpPath), "tmp");
                }
                if (dfsRootPath == null) {
                    logger.warn("The {} property was not configured", (Object)"drillJDBCUnitTests.dfs.root");
                } else {
                    StoragePluginTestUtils.updateSchemaLocation("dfs", pluginRegistry, new File(dfsRootPath), "root");
                }
                if (dfsDefaultPath == null) {
                    logger.warn("The {} property was not configured", (Object)"drillJDBCUnitTests.dfs.default");
                } else {
                    StoragePluginTestUtils.updateSchemaLocation("dfs", pluginRegistry, new File(dfsDefaultPath), "default");
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to update tmp schema locations. This step is purely for testing purpose. Shouldn't be seen in production code.");
        }
    }
}

