/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.math.BigDecimal;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.UnsupportedConversionError;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.WriterEvents;
import oadd.org.joda.time.Instant;
import oadd.org.joda.time.LocalDate;
import oadd.org.joda.time.LocalTime;
import oadd.org.joda.time.Period;

public abstract class BaseScalarWriter
extends AbstractScalarWriterImpl {
    public static final int MIN_BUFFER_SIZE = 256;
    protected WriterEvents.ColumnWriterListener listener;
    protected byte[] emptyValue;
    protected DrillBuf drillBuf;
    protected int capacity;

    @Override
    public void bindListener(WriterEvents.ColumnWriterListener listener) {
        this.listener = listener;
    }

    @Override
    public void bindSchema(ColumnMetadata schema) {
        super.bindSchema(schema);
        Object defaultValue = schema.decodeDefaultValue();
        if (defaultValue != null) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected abstract void setBuffer();

    protected void realloc(int size) {
        this.vector().reallocRaw(size);
        this.setBuffer();
    }

    protected boolean canExpand(int delta) {
        if (this.listener == null) {
            return true;
        }
        return this.listener.canExpand(this, delta);
    }

    protected void overflowed() {
        if (this.listener == null) {
            throw new UnsupportedOperationException("Overflow not supported");
        }
        this.listener.overflowed(this);
    }

    public abstract void skipNulls();

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public void setNull() {
        throw UnsupportedConversionError.nullError(this.schema());
    }

    @Override
    public void setBoolean(boolean value) {
        throw this.conversionError("boolean");
    }

    @Override
    public void setInt(int value) {
        throw this.conversionError("int");
    }

    @Override
    public void setLong(long value) {
        throw this.conversionError("long");
    }

    @Override
    public void setDouble(double value) {
        throw this.conversionError("double");
    }

    @Override
    public void setString(String value) {
        throw this.conversionError("String");
    }

    @Override
    public void setBytes(byte[] value, int len) {
        throw this.conversionError("bytes");
    }

    @Override
    public void setDecimal(BigDecimal value) {
        throw this.conversionError("Decimal");
    }

    @Override
    public void setPeriod(Period value) {
        throw this.conversionError("Period");
    }

    @Override
    public void setDate(LocalDate value) {
        throw this.conversionError("LocalDate");
    }

    @Override
    public void setTime(LocalTime value) {
        throw this.conversionError("LocalTime");
    }

    @Override
    public void setTimestamp(Instant value) {
        throw this.conversionError("Instant");
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("vectorIndex", this.vectorIndex).attributeIdentity("listener", this.listener).attribute("capacity", this.capacity).endObject();
    }
}

