/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.reader;

import java.util.ArrayList;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ArrayReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import oadd.org.apache.drill.exec.vector.accessor.ObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.TupleReader;
import oadd.org.apache.drill.exec.vector.accessor.VariantReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.AbstractScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import oadd.org.apache.drill.exec.vector.accessor.reader.OffsetVectorReader;
import oadd.org.apache.drill.exec.vector.accessor.reader.ReaderEvents;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import oadd.org.apache.drill.exec.vector.accessor.reader.VectorAccessors;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ArrayReaderImpl
implements ArrayReader,
ReaderEvents {
    protected final AbstractObjectReader elementReader;
    protected ElementReaderIndex elementIndex;
    protected NullStateReader nullStateReader;
    private final ColumnMetadata schema;
    private final VectorAccessor arrayAccessor;
    private final OffsetVectorReader offsetReader;

    public ArrayReaderImpl(ColumnMetadata schema, VectorAccessor va, AbstractObjectReader elementReader) {
        this.schema = schema;
        this.arrayAccessor = va;
        this.elementReader = elementReader;
        this.offsetReader = new OffsetVectorReader(VectorAccessors.arrayOffsetVectorAccessor(va));
    }

    public static ArrayObjectReader buildScalar(ColumnMetadata schema, VectorAccessor arrayAccessor, BaseScalarReader elementReader) {
        elementReader.bindVector(schema, VectorAccessors.arrayDataAccessor(arrayAccessor));
        elementReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        ArrayReaderImpl arrayReader = new ArrayReaderImpl(schema, arrayAccessor, new AbstractScalarReader.ScalarObjectReader(elementReader));
        arrayReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new ArrayObjectReader(arrayReader);
    }

    public static AbstractObjectReader buildTuple(ColumnMetadata schema, VectorAccessor arrayAccessor, AbstractObjectReader elementReader) {
        ArrayReaderImpl arrayReader = new ArrayReaderImpl(schema, arrayAccessor, elementReader);
        arrayReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new ArrayObjectReader(arrayReader);
    }

    public static AbstractObjectReader buildList(ColumnMetadata schema, VectorAccessor listAccessor, AbstractObjectReader elementReader) {
        ArrayReaderImpl arrayReader = new ArrayReaderImpl(schema, listAccessor, elementReader);
        NullStateReaders.ListIsSetVectorStateReader arrayNullState = new NullStateReaders.ListIsSetVectorStateReader(VectorAccessors.listBitsAccessor(listAccessor));
        arrayReader.bindNullState(arrayNullState);
        return new ArrayObjectReader(arrayReader);
    }

    public static AbstractObjectReader buildRepeatedList(ColumnMetadata schema, VectorAccessor listAccessor, AbstractObjectReader elementReader) {
        assert (schema.isArray());
        assert (listAccessor.type().getMinorType() == TypeProtos.MinorType.LIST);
        assert (listAccessor.type().getMode() == TypeProtos.DataMode.REPEATED);
        assert (elementReader.type() == ObjectType.ARRAY);
        ArrayReaderImpl arrayReader = new ArrayReaderImpl(schema, listAccessor, elementReader);
        arrayReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new ArrayObjectReader(arrayReader);
    }

    @Override
    public void bindIndex(ColumnReaderIndex index) {
        this.arrayAccessor.bind(index);
        this.offsetReader.bindIndex(index);
        this.nullStateReader.bindIndex(index);
        this.elementIndex = new ElementReaderIndex(index);
        this.elementReader.events().bindIndex(this.elementIndex);
    }

    @Override
    public void bindNullState(NullStateReader nullStateReader) {
        this.nullStateReader = nullStateReader;
    }

    @Override
    public ObjectType type() {
        return ObjectType.ARRAY;
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public NullStateReader nullStateReader() {
        return this.nullStateReader;
    }

    @Override
    public boolean isNull() {
        return this.nullStateReader.isNull();
    }

    @Override
    public void reposition() {
        long entry = this.offsetReader.getEntry();
        this.elementIndex.reset((int)(entry >> 32), (int)(entry & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public boolean next() {
        if (!this.elementIndex.next()) {
            return false;
        }
        this.elementReader.events().reposition();
        return true;
    }

    public ColumnReaderIndex elementIndex() {
        return this.elementIndex;
    }

    @Override
    public int size() {
        return this.elementIndex.size();
    }

    @Override
    public void setPosn(int posn) {
        this.elementIndex.set(posn);
        this.elementReader.events().reposition();
    }

    @Override
    public void rewind() {
        this.elementIndex.rewind();
    }

    @Override
    public ObjectReader entry() {
        return this.elementReader;
    }

    @Override
    public ObjectType entryType() {
        return this.elementReader.type();
    }

    @Override
    public ScalarReader scalar() {
        return this.entry().scalar();
    }

    @Override
    public TupleReader tuple() {
        return this.entry().tuple();
    }

    @Override
    public ArrayReader array() {
        return this.entry().array();
    }

    @Override
    public VariantReader variant() {
        return this.entry().variant();
    }

    @Override
    public Object getObject() {
        this.rewind();
        ArrayList<Object> elements = new ArrayList<Object>();
        while (this.next()) {
            elements.add(this.elementReader.getObject());
        }
        return elements;
    }

    @Override
    public String getAsString() {
        if (this.isNull()) {
            return "null";
        }
        this.rewind();
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int i = 0;
        while (this.next()) {
            if (i++ > 0) {
                buf.append(", ");
            }
            buf.append(this.elementReader.getAsString());
        }
        buf.append("]");
        return buf.toString();
    }

    public static class ElementReaderIndex
    implements ColumnReaderIndex {
        protected final ColumnReaderIndex base;
        protected int startOffset;
        protected int length;
        protected int position;

        public ElementReaderIndex(ColumnReaderIndex base) {
            this.base = base;
        }

        @Override
        public int hyperVectorIndex() {
            return 0;
        }

        public void reset(int startOffset, int length) {
            assert (length >= 0);
            assert (startOffset >= 0);
            this.startOffset = startOffset;
            this.length = length;
            this.position = -1;
        }

        public void rewind() {
            this.position = -1;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public int offset() {
            Preconditions.checkElementIndex(this.position, this.length);
            return this.startOffset + this.position;
        }

        @Override
        public boolean next() {
            if (++this.position < this.length) {
                return true;
            }
            this.position = this.length;
            return false;
        }

        public void set(int index) {
            Preconditions.checkPositionIndex(index, this.length);
            this.position = index;
        }

        @Override
        public int logicalIndex() {
            return this.position;
        }
    }

    public static class ArrayObjectReader
    extends AbstractObjectReader {
        private ArrayReaderImpl arrayReader;

        public ArrayObjectReader(ArrayReaderImpl arrayReader) {
            this.arrayReader = arrayReader;
        }

        @Override
        public ArrayReader array() {
            return this.arrayReader;
        }

        @Override
        public Object getObject() {
            return this.arrayReader.getObject();
        }

        @Override
        public String getAsString() {
            return this.arrayReader.getAsString();
        }

        @Override
        public ReaderEvents events() {
            return this.arrayReader;
        }

        @Override
        public ColumnReader reader() {
            return this.arrayReader;
        }
    }
}

