/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.server.options.OptionMetaData;
import oadd.org.apache.drill.exec.server.options.OptionSet;
import oadd.org.apache.drill.exec.server.options.OptionValue;

public abstract class OptionValidator {
    private final String optionName;
    private final OptionDescription description;

    public OptionValidator(String optionName, OptionDescription description) {
        this.optionName = optionName;
        this.description = description;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public OptionDescription getOptionDescription() {
        return this.description;
    }

    public boolean isShortLived() {
        return false;
    }

    public int getTtl() {
        if (!this.isShortLived()) {
            throw new UnsupportedOperationException("This option is not short-lived.");
        }
        return 0;
    }

    public abstract void validate(OptionValue var1, OptionMetaData var2, OptionSet var3);

    public abstract OptionValue.Kind getKind();

    public String getConfigProperty() {
        return ExecConstants.bootDefaultFor(this.getOptionName());
    }

    public static class OptionDescription {
        private String description;
        private String shortDescription;

        public OptionDescription(String description) {
            this(description, null);
        }

        public OptionDescription(String description, String shortDescription) {
            this.description = description;
            this.shortDescription = shortDescription;
        }

        public String getDescription() {
            return this.description;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public boolean hasShortDescription() {
            return this.shortDescription != null;
        }
    }
}

