/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class WritableBatch
implements AutoCloseable {
    private final UserBitShared.RecordBatchDef def;
    private final DrillBuf[] buffers;
    private boolean cleared = false;

    private WritableBatch(UserBitShared.RecordBatchDef def, List<DrillBuf> buffers) {
        this.def = def;
        this.buffers = buffers.toArray(new DrillBuf[buffers.size()]);
    }

    private WritableBatch(UserBitShared.RecordBatchDef def, DrillBuf[] buffers) {
        this.def = def;
        this.buffers = buffers;
    }

    public WritableBatch transfer(BufferAllocator allocator) {
        ArrayList<DrillBuf> newBuffers = Lists.newArrayList();
        for (DrillBuf buf : this.buffers) {
            int writerIndex = buf.writerIndex();
            DrillBuf newBuf = buf.transferOwnership((BufferAllocator)allocator).buffer;
            newBuf.writerIndex(writerIndex);
            newBuffers.add(newBuf);
        }
        this.clear();
        return new WritableBatch(this.def, newBuffers);
    }

    public UserBitShared.RecordBatchDef getDef() {
        return this.def;
    }

    public DrillBuf[] getBuffers() {
        return this.buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstructContainer(BufferAllocator allocator, VectorContainer container) {
        Preconditions.checkState(!this.cleared, "Attempted to reconstruct a container from a WritableBatch after it had been cleared");
        if (this.buffers.length > 0) {
            int len = 0;
            for (DrillBuf b : this.buffers) {
                len += b.capacity();
            }
            DrillBuf newBuf = allocator.buffer(len);
            try {
                int offset = 0;
                for (DrillBuf buf : this.buffers) {
                    newBuf.setBytes(offset, buf);
                    offset += buf.capacity();
                    buf.release();
                }
                List<UserBitShared.SerializedField> fields = this.def.getFieldList();
                int bufferOffset = 0;
                int vectorIndex = 0;
                for (VectorWrapper<?> vv : container) {
                    UserBitShared.SerializedField fmd = fields.get(vectorIndex);
                    Object v = vv.getValueVector();
                    DrillBuf bb = newBuf.slice(bufferOffset, fmd.getBufferLength());
                    v.load(fmd, bb);
                    ++vectorIndex;
                    bufferOffset += fmd.getBufferLength();
                }
            }
            finally {
                newBuf.release(1);
            }
        }
        BatchSchema.SelectionVectorMode svMode = this.def.hasCarriesTwoByteSelectionVector() && this.def.getCarriesTwoByteSelectionVector() ? BatchSchema.SelectionVectorMode.TWO_BYTE : BatchSchema.SelectionVectorMode.NONE;
        container.buildSchema(svMode);
        for (VectorWrapper v : container) {
            ValueVector.Mutator m4 = v.getValueVector().getMutator();
            m4.setValueCount(this.def.getRecordCount());
        }
    }

    public void clear() {
        if (this.cleared) {
            return;
        }
        for (DrillBuf buf : this.buffers) {
            buf.release();
        }
        this.cleared = true;
    }

    public static WritableBatch getBatchNoHVWrap(int recordCount, Iterable<VectorWrapper<?>> vws, boolean isSV2) {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper<?> vw : vws) {
            Preconditions.checkArgument(!vw.isHyper());
            vectors.add((ValueVector)vw.getValueVector());
        }
        return WritableBatch.getBatchNoHV(recordCount, vectors, isSV2);
    }

    public static WritableBatch getBatchNoHV(int recordCount, Iterable<ValueVector> vectors, boolean isSV2) {
        ArrayList<DrillBuf> buffers = Lists.newArrayList();
        ArrayList<UserBitShared.SerializedField> metadata = Lists.newArrayList();
        for (ValueVector vv : vectors) {
            metadata.add(vv.getMetadata());
            if (recordCount == 0) {
                vv.clear();
                continue;
            }
            for (DrillBuf b : vv.getBuffers(true)) {
                buffers.add(b);
            }
            vv.clear();
        }
        UserBitShared.RecordBatchDef batchDef = UserBitShared.RecordBatchDef.newBuilder().addAllField(metadata).setRecordCount(recordCount).setCarriesTwoByteSelectionVector(isSV2).build();
        WritableBatch b = new WritableBatch(batchDef, buffers);
        return b;
    }

    public static WritableBatch get(VectorAccessible batch) {
        if (batch.getSchema() != null && batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            throw new UnsupportedOperationException("Only batches without hyper selections vectors are writable.");
        }
        boolean sv2 = batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(batch.getRecordCount(), batch, sv2);
    }

    public void retainBuffers(int increment) {
        for (DrillBuf buf : this.buffers) {
            buf.retain(increment);
        }
    }

    @Override
    public void close() {
        for (DrillBuf drillBuf : this.buffers) {
            drillBuf.release(1);
        }
    }
}

