/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.org.apache.calcite.avatica.util.TimeUnit;
import oadd.org.apache.calcite.rel.type.RelDataType;
import oadd.org.apache.calcite.rel.type.RelDataTypeFactory;
import oadd.org.apache.calcite.sql.SqlIntervalQualifier;
import oadd.org.apache.calcite.sql.parser.SqlParserPos;
import oadd.org.apache.calcite.sql.type.SqlTypeFamily;
import oadd.org.apache.calcite.sql.type.SqlTypeName;
import oadd.org.apache.drill.exec.planner.StarColumnHelper;
import oadd.org.apache.drill.exec.planner.types.AbstractRelDataTypeHolder;
import oadd.org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import oadd.org.apache.drill.exec.planner.types.RelDataTypeHolder;

@JsonTypeName(value="view")
public class View {
    private final String name;
    private String sql;
    private List<Field> fields;
    private List<String> workspaceSchemaPath;

    public View(String name, String sql, RelDataType rowType, List<String> workspaceSchemaPath) {
        this(name, sql, rowType.getFieldList().stream().map(f -> new Field(f.getName(), f.getType())).collect(Collectors.toList()), workspaceSchemaPath);
    }

    @JsonCreator
    public View(@JsonProperty(value="name") String name, @JsonProperty(value="sql") String sql, @JsonProperty(value="fields") List<Field> fields, @JsonProperty(value="workspaceSchemaPath") List<String> workspaceSchemaPath) {
        this.name = name;
        this.sql = sql;
        this.fields = fields;
        this.workspaceSchemaPath = workspaceSchemaPath == null ? Collections.EMPTY_LIST : workspaceSchemaPath.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public RelDataType getRowType(RelDataTypeFactory factory) {
        if (this.isDynamic()) {
            return new RelDataTypeDrillImpl((AbstractRelDataTypeHolder)new RelDataTypeHolder(), factory);
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>(this.fields.size());
        ArrayList<String> names = new ArrayList<String>(this.fields.size());
        for (Field field : this.fields) {
            names.add(field.getName());
            types.add(this.getType(field, factory));
        }
        return factory.createStructType(types, names);
    }

    private RelDataType getType(Field field, RelDataTypeFactory factory) {
        SqlTypeName typeName = field.getType();
        Integer precision = field.getPrecision();
        Integer scale = field.getScale();
        RelDataType type = field.isInterval() ? factory.createSqlIntervalType(field.getIntervalQualifier()) : (precision != null ? (scale != null ? factory.createSqlType(typeName, precision.intValue(), scale.intValue()) : factory.createSqlType(typeName, precision.intValue())) : (typeName == SqlTypeName.MAP ? (field.isMapTypesPresent() ? factory.createMapType(this.getType(field.getKeyType(), factory), this.getType(field.getValueType(), factory)) : factory.createSqlType(SqlTypeName.ANY)) : factory.createSqlType(field.getType())));
        return field.getIsNullable() != false ? factory.createTypeWithNullability(type, true) : type;
    }

    @JsonIgnore
    public boolean isDynamic() {
        return this.fields.isEmpty();
    }

    @JsonIgnore
    public boolean hasStar() {
        for (Field field : this.fields) {
            if (!StarColumnHelper.isNonPrefixedStarColumn((String)field.getName())) continue;
            return true;
        }
        return false;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getName() {
        return this.name;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<String> getWorkspaceSchemaPath() {
        return this.workspaceSchemaPath;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Field {
        private final String name;
        private final SqlTypeName type;
        private final Boolean isNullable;
        private Integer precision;
        private Integer scale;
        private SqlIntervalQualifier intervalQualifier;
        private Field keyType;
        private Field valueType;

        @JsonCreator
        public Field(@JsonProperty(value="name") String name, @JsonProperty(value="type") SqlTypeName type, @JsonProperty(value="precision") Integer precision, @JsonProperty(value="scale") Integer scale, @JsonProperty(value="startUnit") TimeUnit startUnit, @JsonProperty(value="endUnit") TimeUnit endUnit, @JsonProperty(value="fractionalSecondPrecision") Integer fractionalSecondPrecision, @JsonProperty(value="isNullable") Boolean isNullable, @JsonProperty(value="keyType") Field keyType, @JsonProperty(value="valueType") Field valueType) {
            this.name = "*".equals(name) ? "**" : name;
            this.type = "*".equals(name) && type == SqlTypeName.ANY ? SqlTypeName.DYNAMIC_STAR : type;
            this.precision = precision;
            this.scale = scale;
            this.intervalQualifier = null == startUnit ? null : new SqlIntervalQualifier(startUnit, precision.intValue(), endUnit, fractionalSecondPrecision.intValue(), SqlParserPos.ZERO);
            this.isNullable = isNullable == null || isNullable != false;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public Field(String name, RelDataType dataType) {
            this.name = name;
            this.type = dataType.getSqlTypeName();
            this.isNullable = dataType.isNullable();
            this.intervalQualifier = dataType.getIntervalQualifier();
            switch (dataType.getSqlTypeName()) {
                case CHAR: 
                case BINARY: 
                case VARBINARY: 
                case VARCHAR: {
                    this.precision = dataType.getPrecision();
                    break;
                }
                case DECIMAL: {
                    this.precision = dataType.getPrecision();
                    this.scale = dataType.getScale();
                    break;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    this.precision = dataType.getIntervalQualifier().getStartPrecisionPreservingDefault();
                    break;
                }
                case MAP: {
                    this.keyType = new Field(dataType.getKeyType());
                    this.valueType = new Field(dataType.getValueType());
                }
            }
        }

        public Field(RelDataType dataType) {
            this(null, dataType);
        }

        public String getName() {
            return this.name;
        }

        public SqlTypeName getType() {
            return this.type;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Integer getScale() {
            return this.scale;
        }

        @JsonIgnore
        public SqlIntervalQualifier getIntervalQualifier() {
            return this.intervalQualifier;
        }

        public TimeUnit getStartUnit() {
            return null == this.intervalQualifier ? null : this.intervalQualifier.getStartUnit();
        }

        public TimeUnit getEndUnit() {
            return null == this.intervalQualifier ? null : this.intervalQualifier.getEndUnit();
        }

        public Integer getFractionalSecondPrecision() {
            return null == this.intervalQualifier ? null : Integer.valueOf(this.intervalQualifier.getFractionalSecondPrecisionPreservingDefault());
        }

        public Boolean getIsNullable() {
            return this.isNullable;
        }

        public Field getKeyType() {
            return this.keyType;
        }

        public Field getValueType() {
            return this.valueType;
        }

        @JsonIgnore
        boolean isInterval() {
            SqlTypeFamily family = this.type.getFamily();
            return family == SqlTypeFamily.INTERVAL_YEAR_MONTH || family == SqlTypeFamily.INTERVAL_DAY_TIME;
        }

        @JsonIgnore
        boolean isMapTypesPresent() {
            return this.keyType != null && this.valueType != null;
        }
    }
}

