/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.core.JsonGenerator;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JavaType;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.JsonMappingException;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import oadd.org.apache.calcite.avatica.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

