
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/*
 * This class is automatically generated from AddTypes.tdd using FreeMarker.
 */


package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the MathFunctionTemplates.java template.
 */
@SuppressWarnings("unused")

public class SubtractFunctions {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(SubtractFunctions.class);


  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class IntIntSubtract implements DrillSimpleFunc {

    @Param IntHolder in1;
    @Param IntHolder in2;
    @Output IntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (int) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class BigIntBigIntSubtract implements DrillSimpleFunc {

    @Param BigIntHolder in1;
    @Param BigIntHolder in2;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (long) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class Float4Float4Subtract implements DrillSimpleFunc {

    @Param Float4Holder in1;
    @Param Float4Holder in2;
    @Output Float4Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = (float) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class Float8Float8Subtract implements DrillSimpleFunc {

    @Param Float8Holder in1;
    @Param Float8Holder in2;
    @Output Float8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = (double) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class SmallIntSmallIntSubtract implements DrillSimpleFunc {

    @Param SmallIntHolder in1;
    @Param SmallIntHolder in2;
    @Output SmallIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (short) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class TinyIntTinyIntSubtract implements DrillSimpleFunc {

    @Param TinyIntHolder in1;
    @Param TinyIntHolder in2;
    @Output TinyIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (byte) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class UInt1UInt1Subtract implements DrillSimpleFunc {

    @Param UInt1Holder in1;
    @Param UInt1Holder in2;
    @Output UInt1Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = (byte) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class UInt2UInt2Subtract implements DrillSimpleFunc {

    @Param UInt2Holder in1;
    @Param UInt2Holder in2;
    @Output UInt2Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = (char) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class UInt4UInt4Subtract implements DrillSimpleFunc {

    @Param UInt4Holder in1;
    @Param UInt4Holder in2;
    @Output UInt4Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = (int) (in1.value - in2.value);
    }
  }

  @FunctionTemplate(name = "subtract", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
  public static class UInt8UInt8Subtract implements DrillSimpleFunc {

    @Param UInt8Holder in1;
    @Param UInt8Holder in2;
    @Output UInt8Holder out;

    public void setup() {
    }

    public void eval() {
      out.value = (long) (in1.value - in2.value);
    }
  }
}
