



package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;

/*
 * This class is generated using freemarker and the CovarTypeFunctions.java template.
 */

@SuppressWarnings("unused")

public class CoVarianceSampleFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(CoVarianceSampleFunctions.class);


@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class BigIntCoVarianceSample implements DrillAggFunc{

  @Param BigIntHolder xIn;
  @Param BigIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableBigIntCoVarianceSample implements DrillAggFunc{

  @Param NullableBigIntHolder xIn;
  @Param NullableBigIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntCoVarianceSample implements DrillAggFunc{

  @Param IntHolder xIn;
  @Param IntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntCoVarianceSample implements DrillAggFunc{

  @Param NullableIntHolder xIn;
  @Param NullableIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class SmallIntCoVarianceSample implements DrillAggFunc{

  @Param SmallIntHolder xIn;
  @Param SmallIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableSmallIntCoVarianceSample implements DrillAggFunc{

  @Param NullableSmallIntHolder xIn;
  @Param NullableSmallIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class TinyIntCoVarianceSample implements DrillAggFunc{

  @Param TinyIntHolder xIn;
  @Param TinyIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableTinyIntCoVarianceSample implements DrillAggFunc{

  @Param NullableTinyIntHolder xIn;
  @Param NullableTinyIntHolder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt1CoVarianceSample implements DrillAggFunc{

  @Param UInt1Holder xIn;
  @Param UInt1Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt1CoVarianceSample implements DrillAggFunc{

  @Param NullableUInt1Holder xIn;
  @Param NullableUInt1Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt2CoVarianceSample implements DrillAggFunc{

  @Param UInt2Holder xIn;
  @Param UInt2Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt2CoVarianceSample implements DrillAggFunc{

  @Param NullableUInt2Holder xIn;
  @Param NullableUInt2Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt4CoVarianceSample implements DrillAggFunc{

  @Param UInt4Holder xIn;
  @Param UInt4Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt4CoVarianceSample implements DrillAggFunc{

  @Param NullableUInt4Holder xIn;
  @Param NullableUInt4Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt8CoVarianceSample implements DrillAggFunc{

  @Param UInt8Holder xIn;
  @Param UInt8Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt8CoVarianceSample implements DrillAggFunc{

  @Param NullableUInt8Holder xIn;
  @Param NullableUInt8Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float4CoVarianceSample implements DrillAggFunc{

  @Param Float4Holder xIn;
  @Param Float4Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat4CoVarianceSample implements DrillAggFunc{

  @Param NullableFloat4Holder xIn;
  @Param NullableFloat4Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float8CoVarianceSample implements DrillAggFunc{

  @Param Float8Holder xIn;
  @Param Float8Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}



@FunctionTemplate(names = {"covar_samp", "covariance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat8CoVarianceSample implements DrillAggFunc{

  @Param NullableFloat8Holder xIn;
  @Param NullableFloat8Holder yIn;

  @Workspace Float8Holder xMean;
  @Workspace Float8Holder yMean;
  @Workspace Float8Holder xyMean;

  @Workspace Float8Holder covar;

  @Workspace BigIntHolder count;
  @Output Float8Holder out;

  public void setup() {
    xMean = new Float8Holder();
    yMean = new Float8Holder();
    xyMean = new Float8Holder();
    count = new BigIntHolder();
    covar = new Float8Holder();

    // Initialize the workspace variables
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }

  @Override
  public void add() {
	  sout: {
	  if (xIn.isSet == 0 || yIn.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    // compute covariance
    xMean.value += ((xIn.value - xMean.value) / count.value);
    yMean.value += ((yIn.value - yMean.value) / count.value);

    xyMean.value += ((xIn.value * yIn.value) - xyMean.value) / count.value;
    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
      out.value = (xyMean.value - (xMean.value * yMean.value))*(count.value - 1)/(count.value - 2);
  }

  @Override
  public void reset() {
    xMean.value = 0;
    yMean.value = 0;
    xyMean.value = 0;
    count.value = 1;
    covar.value = 0;
  }
}


}
