

package org.apache.drill.exec.expr.fn.impl;

import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkArgument;
import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkState;

import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;

import java.nio.ByteBuffer;

@SuppressWarnings("unused")
public class VarDecimalFunctions {

  @FunctionTemplate(name = "subtract",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_ADD_SCALE,
                    nulls = NullHandling.NULL_IF_NULL,
                    checkPrecisionRange = true)
  public static class VarDecimalSubtractFunction implements DrillSimpleFunc {
    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Inject DrillBuf buffer;
    @Output VarDecimalHolder result;

    public void setup() {
    }

    public void eval() {
      result.start = 0;

      java.math.BigDecimal leftInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale);
      java.math.BigDecimal rightInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(right.buffer, right.start, right.end - right.start, right.scale);
      org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision typeInference =
          new org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionAddFunction(
              left.precision, left.scale,
              right.precision, right.scale);

      result.scale = typeInference.getOutputScale();
      result.precision = typeInference.getOutputPrecision();

      java.math.BigDecimal opResult =
          leftInput.subtract(rightInput,
              new java.math.MathContext(result.precision, java.math.RoundingMode.HALF_UP))
            .setScale(result.scale, java.math.BigDecimal.ROUND_HALF_UP);

      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(opResult, result.precision, result.scale);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "add",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_ADD_SCALE,
                    nulls = NullHandling.NULL_IF_NULL,
                    checkPrecisionRange = true)
  public static class VarDecimalAddFunction implements DrillSimpleFunc {
    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Inject DrillBuf buffer;
    @Output VarDecimalHolder result;

    public void setup() {
    }

    public void eval() {
      result.start = 0;

      java.math.BigDecimal leftInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale);
      java.math.BigDecimal rightInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(right.buffer, right.start, right.end - right.start, right.scale);
      org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision typeInference =
          new org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionAddFunction(
              left.precision, left.scale,
              right.precision, right.scale);

      result.scale = typeInference.getOutputScale();
      result.precision = typeInference.getOutputPrecision();

      java.math.BigDecimal opResult =
          leftInput.add(rightInput,
              new java.math.MathContext(result.precision, java.math.RoundingMode.HALF_UP))
            .setScale(result.scale, java.math.BigDecimal.ROUND_HALF_UP);

      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(opResult, result.precision, result.scale);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "multiply",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_SUM_SCALE,
                    nulls = NullHandling.NULL_IF_NULL,
                    checkPrecisionRange = true)
  public static class VarDecimalMultiplyFunction implements DrillSimpleFunc {
    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Inject DrillBuf buffer;
    @Output VarDecimalHolder result;

    public void setup() {
    }

    public void eval() {
      result.start = 0;

      java.math.BigDecimal leftInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale);
      java.math.BigDecimal rightInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(right.buffer, right.start, right.end - right.start, right.scale);
      org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision typeInference =
          new org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionMulFunction(
              left.precision, left.scale,
              right.precision, right.scale);

      result.scale = typeInference.getOutputScale();
      result.precision = typeInference.getOutputPrecision();

      java.math.BigDecimal opResult =
          leftInput.multiply(rightInput,
              new java.math.MathContext(result.precision, java.math.RoundingMode.HALF_UP))
            .setScale(result.scale, java.math.BigDecimal.ROUND_HALF_UP);

      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(opResult, result.precision, result.scale);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "divide",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_DIV_SCALE,
                    nulls = NullHandling.NULL_IF_NULL,
                    checkPrecisionRange = true)
  public static class VarDecimalDivideFunction implements DrillSimpleFunc {
    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Inject DrillBuf buffer;
    @Output VarDecimalHolder result;

    public void setup() {
    }

    public void eval() {
      result.start = 0;

      java.math.BigDecimal leftInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale);
      java.math.BigDecimal rightInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(right.buffer, right.start, right.end - right.start, right.scale);
      org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision typeInference =
          new org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionDivideFunction(
              left.precision, left.scale,
              right.precision, right.scale);

      result.scale = typeInference.getOutputScale();
      result.precision = typeInference.getOutputPrecision();

      java.math.BigDecimal opResult =
          leftInput.divide(rightInput,
              new java.math.MathContext(result.precision, java.math.RoundingMode.HALF_UP))
            .setScale(result.scale, java.math.BigDecimal.ROUND_HALF_UP);

      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(opResult, result.precision, result.scale);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "mod",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MOD_SCALE,
                    nulls = NullHandling.NULL_IF_NULL,
                    checkPrecisionRange = true)
  public static class VarDecimalModFunction implements DrillSimpleFunc {
    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Inject DrillBuf buffer;
    @Output VarDecimalHolder result;

    public void setup() {
    }

    public void eval() {
      result.start = 0;

      java.math.BigDecimal leftInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale);
      java.math.BigDecimal rightInput =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(right.buffer, right.start, right.end - right.start, right.scale);
      org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision typeInference =
          new org.apache.drill.exec.planner.types.decimal.DecimalScalePrecisionModFunction(
              left.precision, left.scale,
              right.precision, right.scale);

      result.scale = typeInference.getOutputScale();
      result.precision = typeInference.getOutputPrecision();

      java.math.BigDecimal opResult =
        leftInput.remainder(rightInput,
              new java.math.MathContext(result.precision, java.math.RoundingMode.HALF_UP))
            .setScale(result.scale, java.math.BigDecimal.ROUND_HALF_UP);

      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(opResult, result.precision, result.scale);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }


  @FunctionTemplate(name = "abs",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalAbsFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder in;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.precision = in.precision;

      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale)
                  .abs();
      result.scale = in.scale;

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(names = {"ceil", "ceiling"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalCeilFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder in;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.precision = in.precision;

      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale)
                  .setScale(0, java.math.BigDecimal.ROUND_CEILING);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "floor",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalFloorFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder in;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.precision = in.precision;

      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale)
                  .setScale(0, java.math.BigDecimal.ROUND_FLOOR);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(names = {"trunc", "truncate"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalTruncFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder in;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.precision = in.precision;

      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale)
                  .setScale(0, java.math.BigDecimal.ROUND_DOWN);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "round",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_ZERO_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalRoundFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder in;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.precision = in.precision;

      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale)
                  .setScale(0, java.math.BigDecimal.ROUND_HALF_UP);

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(names = {"negative", "u-", "-"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalNegativeFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder in;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.precision = in.precision;

      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale)
                  .negate();
      result.scale = in.scale;

      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "sign",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalSignFunction implements DrillSimpleFunc {
    @Param VarDecimalHolder in;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      // TODO: optimize to get only bytes that corresponds to sign.
      // Should be taken into account case when leading zero bytes are stored in buff.
      java.math.BigDecimal bd =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
      out.value = bd.signum();
    }
  }

  @FunctionTemplate(names = {"trunc", "truncate"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_SET_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalTruncateScaleFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder left;
    @Param  IntHolder right;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.start = 0;
      result.scale = Math.max(right.value, 0);
      result.precision = left.precision;
      java.math.BigDecimal opResult =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale)
                  .setScale(result.scale, java.math.BigDecimal.ROUND_DOWN);
      byte[] bytes = opResult.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }

  @FunctionTemplate(name = "round",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_SET_SCALE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalRoundScaleFunction implements DrillSimpleFunc {
    @Param  VarDecimalHolder left;
    @Param  IntHolder right;
    @Output VarDecimalHolder result;
    @Inject DrillBuf buffer;

    public void setup() {
    }

    public void eval() {
      result.scale = Math.max(right.value, 0);
      result.precision = left.precision;
      result.start = 0;
      java.math.BigDecimal bd =
          org.apache.drill.exec.util.DecimalUtility
              .getBigDecimalFromDrillBuf(left.buffer, left.start, left.end - left.start, left.scale)
                  .setScale(result.scale, java.math.BigDecimal.ROUND_HALF_UP);
      byte[] bytes = bd.unscaledValue().toByteArray();
      int len = bytes.length;
      result.buffer = buffer.reallocIfNeeded(len);
      result.buffer.setBytes(0, bytes);
      result.end = len;
    }
  }


  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarDecimalVsNullableVarDecimalNullHigh implements DrillSimpleFunc {

    @Param NullableVarDecimalHolder left;
    @Param NullableVarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }


        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarDecimalVsNullableVarDecimalNullLow implements DrillSimpleFunc {

    @Param NullableVarDecimalHolder left;
    @Param NullableVarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }


        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }


  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarDecimalVsVarDecimalNullHigh implements DrillSimpleFunc {

    @Param NullableVarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }


        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarDecimalVsVarDecimalNullLow implements DrillSimpleFunc {

    @Param NullableVarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }


        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }


  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarDecimalVsNullableVarDecimalNullHigh implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param NullableVarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }


        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarDecimalVsNullableVarDecimalNullLow implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param NullableVarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }


        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }


  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarDecimalVsVarDecimalNullHigh implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {



        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarDecimalVsVarDecimalNullLow implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
      outside:
      {



        out.value = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
    }
  }


  @FunctionTemplate(name = FunctionGenerationHelper.LT,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalLessThan implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output BitHolder out;
    public void setup() {}

    public void eval() {
      int cmp;
      outside:
      {


        cmp = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
      out.value = cmp == -1 ? 1 : 0;
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.LE,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalLessThanEq implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      int cmp;
      outside:
      {


        cmp = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
      out.value = cmp < 1 ? 1 : 0;
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.GT,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalGreaterThan implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      int cmp;
      outside:
      {


        cmp = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
      out.value = cmp == 1 ? 1 : 0;
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.GE,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalGreaterThanEq implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      int cmp;
      outside:
      {


        cmp = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
      out.value = cmp > -1 ? 1 : 0;
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.EQ,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalEqual implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      int cmp;
      outside:
      {


        cmp = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
      out.value = cmp == 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.NE,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class VarDecimalNotEqual implements DrillSimpleFunc {

    @Param VarDecimalHolder left;
    @Param VarDecimalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      int cmp;
      outside:
      {


        cmp = org.apache.drill.exec.util.DecimalUtility.compareVarLenBytes(left.buffer, left.start, left.end, left.scale, right.buffer, right.start, right.end, right.scale, false);
      } // outside
      out.value = cmp != 0 ? 1 : 0;
    }
  }
}













