

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/DateIntervalArithmeticFunctions.java template.
 */

public class TimeIntervalFunctions {

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class TimeIntervalAddFunction implements DrillSimpleFunc {
    @Param TimeHolder left;
    @Param IntervalHolder right;
    @Output TimeHolder out;

        public void setup() {
        }

        public void eval() {
    out.value = left.value + right.milliseconds;
    // Wrap around 24 hour clock if we exceeded it while adding the time component
    out.value = out.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalTimeAddFunction implements DrillSimpleFunc {
    @Param IntervalHolder right;
    @Param TimeHolder left;
    @Output TimeHolder out;

        public void setup() {
        }
        public void eval() {
    out.value = left.value + right.milliseconds;
    // Wrap around 24 hour clock if we exceeded it while adding the time component
    out.value = out.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_sub", "subtract", "date_diff"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class TimeIntervalSubtractFunction implements DrillSimpleFunc {
    @Param TimeHolder left;
    @Param IntervalHolder right;
    @Output TimeHolder out;

        public void setup() {
        }

        public void eval() {
    out.value = left.value - right.milliseconds;
    // Wrap around 24 hour clock if we exceeded it while adding the time component
    out.value = out.value % org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
        }
    }
}

