

package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the CastHigh.java template.
 */
public class CastHighFunctions {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(CastHighFunctions.class);


  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighInt implements DrillSimpleFunc {

    @Param IntHolder in;
    @Output Float8Holder out;

    public void setup() {}

    public void eval() {
      out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
    @Output Float8Holder out;

    public void setup() {}

    public void eval() {
      out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
    @Output Float8Holder out;

    public void setup() {}

    public void eval() {
      out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
    @Output Float8Holder out;

    public void setup() {}

    public void eval() {
      out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal9 implements DrillSimpleFunc {

    @Param Decimal9Holder in;
    @Output Decimal9Holder out;

    public void setup() {}

    public void eval() {
      out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal18 implements DrillSimpleFunc {

    @Param Decimal18Holder in;
    @Output Decimal18Holder out;

    public void setup() {}

    public void eval() {
      out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal28Sparse implements DrillSimpleFunc {

    @Param Decimal28SparseHolder in;
    @Output Decimal28SparseHolder out;

    public void setup() {}

    public void eval() {
      out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal38Sparse implements DrillSimpleFunc {

    @Param Decimal38SparseHolder in;
    @Output Decimal38SparseHolder out;

    public void setup() {}

    public void eval() {
      out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AGGREGATE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class CastHighVarDecimal implements DrillSimpleFunc {

    @Param VarDecimalHolder in;
    @Output VarDecimalHolder out;

    public void setup() {}

    public void eval() {
      out = in;
    }
  }
}
