
    package org.apache.drill.exec.expr.fn.impl.gcast;

    import org.apache.drill.exec.expr.DrillSimpleFunc;
    import org.apache.drill.exec.expr.annotations.FunctionTemplate;
    import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
    import org.apache.drill.exec.expr.annotations.Output;
    import org.apache.drill.exec.expr.annotations.Param;
    import org.apache.drill.exec.expr.holders.*;
    import org.apache.drill.exec.record.RecordBatch;
    import javax.inject.Inject;
    import io.netty.buffer.DrillBuf;

/**
 * This file is generated with Freemarker using the template exec/java-exec/src/main/codegen/templates/CastEmptyStringVarTypesToNullableNumeric.java
 */

@SuppressWarnings("unused")
@FunctionTemplate(name = "castEmptyStringNullableVarBinaryToNULLABLEFLOAT8", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL, isInternal=true)
public class CastEmptyStringNullableVarBinaryToNullableFloat8 implements DrillSimpleFunc{

    @Param NullableVarBinaryHolder in;
    @Output NullableFloat8Holder out;

    public void setup() {}

    public void eval() {
        if(in.isSet == 0 || in.end == in.start) {
            out.isSet = 0;
        } else{
            out.isSet = 1;
            byte[]buf=new byte[in.end-in.start];
            in.buffer.getBytes(in.start,buf,0,in.end-in.start);
            out.value=Double.parseDouble(new String(buf,com.google.common.base.Charsets.UTF_8));
        }
        }
}

 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
