

/*
 * This class is generated using freemarker and the AggrTypeFunctions3.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class VarianceSampleFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(VarianceSampleFunctions.class);


@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class BigIntVarianceSample implements DrillAggFunc{

  @Param BigIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableBigIntVarianceSample implements DrillAggFunc{

  @Param NullableBigIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntVarianceSample implements DrillAggFunc{

  @Param IntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntVarianceSample implements DrillAggFunc{

  @Param NullableIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class SmallIntVarianceSample implements DrillAggFunc{

  @Param SmallIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableSmallIntVarianceSample implements DrillAggFunc{

  @Param NullableSmallIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class TinyIntVarianceSample implements DrillAggFunc{

  @Param TinyIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableTinyIntVarianceSample implements DrillAggFunc{

  @Param NullableTinyIntHolder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt1VarianceSample implements DrillAggFunc{

  @Param UInt1Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt1VarianceSample implements DrillAggFunc{

  @Param NullableUInt1Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt2VarianceSample implements DrillAggFunc{

  @Param UInt2Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt2VarianceSample implements DrillAggFunc{

  @Param NullableUInt2Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt4VarianceSample implements DrillAggFunc{

  @Param UInt4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt4VarianceSample implements DrillAggFunc{

  @Param NullableUInt4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class UInt8VarianceSample implements DrillAggFunc{

  @Param UInt8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableUInt8VarianceSample implements DrillAggFunc{

  @Param NullableUInt8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float4VarianceSample implements DrillAggFunc{

  @Param Float4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat4VarianceSample implements DrillAggFunc{

  @Param NullableFloat4Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float8VarianceSample implements DrillAggFunc{

  @Param Float8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}



@FunctionTemplate(names = {"var_samp", "variance"}, scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat8VarianceSample implements DrillAggFunc{

  @Param NullableFloat8Holder in;
  @Workspace Float8Holder avg;
  @Workspace Float8Holder dev;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	avg = new Float8Holder();
    dev = new Float8Holder();
    count = new BigIntHolder();
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    // Initialize the workspace variables
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }

  @Override
  public void add() {
	  sout: {
	  if (in.isSet == 0) {
	   // processing nullable input and the value is null, so don't do anything...
	   break sout;
	  }

    nonNullCount.value = 1;
    // Welford's approach to compute standard deviation
    double temp = avg.value;
    avg.value += ((in.value - temp) / count.value);
    dev.value += (in.value - temp) * (in.value - avg.value);
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      if (count.value > 2)
        out.value = (dev.value / (count.value - 2));
     } else {
       out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    avg.value = 0;
    dev.value = 0;
    count.value = 1;
  }
}


}
