



package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

/*
 * This class is generated using freemarker and the DateIntervalAggrFunctions1.java template.
 */

@SuppressWarnings("unused")

public class SumDateTypeFunctions {

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalDaySum implements DrillAggFunc {

  @Param IntervalDayHolder in;
  @Workspace IntervalDayHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalDayHolder out;

  public void setup() {
	  value = new IntervalDayHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    value.days += in.days;
    value.milliseconds += in.milliseconds;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.days = value.days;
      out.milliseconds = value.milliseconds;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalDaySum implements DrillAggFunc {

  @Param NullableIntervalDayHolder in;
  @Workspace IntervalDayHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalDayHolder out;

  public void setup() {
	  value = new IntervalDayHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    value.days += in.days;
    value.milliseconds += in.milliseconds;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.days = value.days;
      out.milliseconds = value.milliseconds;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalYearSum implements DrillAggFunc {

  @Param IntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalYearHolder out;

  public void setup() {
	  value = new IntervalYearHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = 0;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
	    value.value += in.value;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalYearSum implements DrillAggFunc {

  @Param NullableIntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalYearHolder out;

  public void setup() {
	  value = new IntervalYearHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
	    value.value += in.value;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.value = value.value;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.value = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalSum implements DrillAggFunc {

  @Param IntervalHolder in;
  @Workspace IntervalHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
	  value = new IntervalHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    value.days += in.days;
    value.months += in.months;
    value.milliseconds += in.milliseconds;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.months = value.months;
      out.days = value.days;
      out.milliseconds = value.milliseconds;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

 }

@FunctionTemplate(name = "sum", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalSum implements DrillAggFunc {

  @Param NullableIntervalHolder in;
  @Workspace IntervalHolder value;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
	  value = new IntervalHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    value.days += in.days;
    value.months += in.months;
    value.milliseconds += in.milliseconds;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      out.months = value.months;
      out.days = value.days;
      out.milliseconds = value.milliseconds;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    value.months = 0;
    value.days= 0;
    value.milliseconds = 0;
  }

 }

}
