

/*
 * This class is generated using freemarker and the ComplexAggrFunctions1.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.MapUtility;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.*;

@SuppressWarnings("unused")

public class SingleValueComplexFunctions {


  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class ListSingleValue implements DrillAggFunc {
    @Param ListHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class MapSingleValue implements DrillAggFunc {
    @Param MapHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createMap(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedBitSingleValue implements DrillAggFunc {
    @Param RepeatedBitHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedIntSingleValue implements DrillAggFunc {
    @Param RepeatedIntHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedBigIntSingleValue implements DrillAggFunc {
    @Param RepeatedBigIntHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedFloat4SingleValue implements DrillAggFunc {
    @Param RepeatedFloat4Holder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedFloat8SingleValue implements DrillAggFunc {
    @Param RepeatedFloat8Holder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedDateSingleValue implements DrillAggFunc {
    @Param RepeatedDateHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedTimeStampSingleValue implements DrillAggFunc {
    @Param RepeatedTimeStampHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedTimeSingleValue implements DrillAggFunc {
    @Param RepeatedTimeHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedIntervalDaySingleValue implements DrillAggFunc {
    @Param RepeatedIntervalDayHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedIntervalYearSingleValue implements DrillAggFunc {
    @Param RepeatedIntervalYearHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedIntervalSingleValue implements DrillAggFunc {
    @Param RepeatedIntervalHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedVarCharSingleValue implements DrillAggFunc {
    @Param RepeatedVarCharHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedVarBinarySingleValue implements DrillAggFunc {
    @Param RepeatedVarBinaryHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedVarDecimalSingleValue implements DrillAggFunc {
    @Param RepeatedVarDecimalHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedListSingleValue implements DrillAggFunc {
    @Param RepeatedListHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createRepeatedMapOrList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }

  @FunctionTemplate(name = "single_value",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class RepeatedMapSingleValue implements DrillAggFunc {
    @Param RepeatedMapHolder inHolder;
    @Workspace BigIntHolder nonNullCount;
    @Output ComplexWriter writer;

    public void setup() {
      nonNullCount = new BigIntHolder();
      nonNullCount.value = 0;
    }

    @Override
    public void add() {
      if (nonNullCount.value > 0) {
        throw org.apache.drill.common.exceptions.UserException.functionError()
            .message("Input for single_value function has more than one row")
            .build();
      }
      if (nonNullCount.value == 0) {
        org.apache.drill.exec.expr.fn.impl.MappifyUtility.createRepeatedMapOrList(inHolder.reader, writer, "single_value");
      }
      nonNullCount.value = 1;
    }

    @Override
    public void output() {
      //Do nothing since the complex writer takes care of everything!
    }

    @Override
    public void reset() {
      nonNullCount.value = 0;
    }
  }
}
