

/*
 * This class is generated using freemarker and the AggrTypeFunctions2.java template.
 */



package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class AvgFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(AvgFunctions.class);
 

@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntAvg implements DrillAggFunc{

  @Param IntHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new BigIntHolder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class BigIntAvg implements DrillAggFunc{

  @Param BigIntHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new BigIntHolder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntAvg implements DrillAggFunc{

  @Param NullableIntHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new BigIntHolder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    } 
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableBigIntAvg implements DrillAggFunc{

  @Param NullableBigIntHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new BigIntHolder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    } 
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float4Avg implements DrillAggFunc{

  @Param Float4Holder in;
  @Workspace Float8Holder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new Float8Holder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class Float8Avg implements DrillAggFunc{

  @Param Float8Holder in;
  @Workspace Float8Holder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new Float8Holder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat4Avg implements DrillAggFunc{

  @Param NullableFloat4Holder in;
  @Workspace Float8Holder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new Float8Holder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    } 
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableFloat8Avg implements DrillAggFunc{

  @Param NullableFloat8Holder in;
  @Workspace Float8Holder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableFloat8Holder out;

  public void setup() {
  	sum = new Float8Holder();  
    count = new BigIntHolder();  
  	nonNullCount = new BigIntHolder();
  	nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }
  
  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    } 
    nonNullCount.value = 1;
 	    sum.value += in.value;
 	    count.value++;
    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.value = sum.value / ((double) count.value);
      out.isSet = 1;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }

}

