

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/DateIntervalArithmeticFunctions.java template.
 */

public class TimeBigIntFunctions {

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class TimeBigIntAddFunction implements DrillSimpleFunc {
    @Param TimeHolder left;
    @Param BigIntHolder right;
    @Output TimeHolder out;

        public void setup() {
        }

        public void eval() {
    if (1 == 1) {
        throw new UnsupportedOperationException("Cannot add integer to TIME, cast it to specific interval");
    }
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class BigIntTimeAddFunction implements DrillSimpleFunc {
    @Param BigIntHolder right;
    @Param TimeHolder left;
    @Output TimeHolder out;

        public void setup() {
        }
        public void eval() {
    if (1 == 1) {
        throw new UnsupportedOperationException("Cannot add integer to TIME, cast it to specific interval");
    }
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_sub", "subtract", "date_diff"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class TimeBigIntSubtractFunction implements DrillSimpleFunc {
    @Param TimeHolder left;
    @Param BigIntHolder right;
    @Output TimeHolder out;

        public void setup() {
        }

        public void eval() {
    if (1 == 1) {
        throw new UnsupportedOperationException("Cannot add integer to TIME, cast it to specific interval");
    }
        }
    }
}
