

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/ToTimeStampFunction.java template.
 */

@FunctionTemplate(name = "to_timestamp",
                  scope = FunctionTemplate.FunctionScope.SIMPLE,
                  nulls = NullHandling.NULL_IF_NULL)
public class GUInt2ToTimeStamp implements DrillSimpleFunc {

  @Param  UInt2Holder left;
  @Output TimeStampHolder out;

  public void setup() {
  }

  public void eval() {
    long inputMillis = 0;

    inputMillis = (long) (left.value * 1000L);
    out.value = new org.joda.time.DateTime(inputMillis).withZoneRetainFields(org.joda.time.DateTimeZone.UTC).getMillis();
  }
}

