

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

import io.netty.buffer.ByteBuf;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/DateDateArithmeticFunctions.java template.
 */

@SuppressWarnings("unused")
public class GDateArithmetic {
@SuppressWarnings("unused")

@FunctionTemplate(names = {"date_diff", "subtract", "date_sub"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class GDateDifference implements DrillSimpleFunc {

    @Param  DateHolder left;
    @Param  DateHolder right;
    @Output IntervalDayHolder out;

    public void setup() {
    }

    public void eval() {
        out.days = (int) ((left.value - right.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis);
    }
}
}

