

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareVarCharVsVarChar {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarCharVsVarCharNullHigh implements DrillSimpleFunc {

    @Param VarCharHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarCharVsVarCharNullLow implements DrillSimpleFunc {

    @Param VarCharHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarCharVsNullableVarCharNullHigh implements DrillSimpleFunc {

    @Param VarCharHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareVarCharVsNullableVarCharNullLow implements DrillSimpleFunc {

    @Param VarCharHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarCharVsVarCharNullHigh implements DrillSimpleFunc {

    @Param NullableVarCharHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarCharVsVarCharNullLow implements DrillSimpleFunc {

    @Param NullableVarCharHolder left;
    @Param VarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarCharVsNullableVarCharNullHigh implements DrillSimpleFunc {

    @Param NullableVarCharHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableVarCharVsNullableVarCharNullLow implements DrillSimpleFunc {

    @Param NullableVarCharHolder left;
    @Param NullableVarCharHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanVarCharVsVarChar implements DrillSimpleFunc {

      @Param VarCharHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == -1 ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqVarCharVsVarChar implements DrillSimpleFunc {

      @Param VarCharHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp < 1 ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanVarCharVsVarChar implements DrillSimpleFunc {

      @Param VarCharHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == 1 ? 1 : 0;

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqVarCharVsVarChar implements DrillSimpleFunc {

      @Param VarCharHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp > -1 ? 1 : 0;

      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsVarCharVsVarChar implements DrillSimpleFunc {

      @Param VarCharHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          out.value = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.equal(
              left.buffer, left.start, left.end, right.buffer, right.start, right.end);

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsVarCharVsVarChar implements DrillSimpleFunc {

      @Param VarCharHolder left;
      @Param VarCharHolder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

          int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      cmp = org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          left.buffer, left.start, left.end, right.buffer, right.start, right.end );

      } // outside
          out.value = cmp == 0 ? 0 : 1;

      }
  }

}



