

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareFloat8VsFloat8 {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareFloat8VsFloat8NullHigh implements DrillSimpleFunc {

    @Param Float8Holder left;
    @Param Float8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareFloat8VsFloat8NullLow implements DrillSimpleFunc {

    @Param Float8Holder left;
    @Param Float8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareFloat8VsNullableFloat8NullHigh implements DrillSimpleFunc {

    @Param Float8Holder left;
    @Param NullableFloat8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareFloat8VsNullableFloat8NullLow implements DrillSimpleFunc {

    @Param Float8Holder left;
    @Param NullableFloat8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableFloat8VsFloat8NullHigh implements DrillSimpleFunc {

    @Param NullableFloat8Holder left;
    @Param Float8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableFloat8VsFloat8NullLow implements DrillSimpleFunc {

    @Param NullableFloat8Holder left;
    @Param Float8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableFloat8VsNullableFloat8NullHigh implements DrillSimpleFunc {

    @Param NullableFloat8Holder left;
    @Param NullableFloat8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableFloat8VsNullableFloat8NullLow implements DrillSimpleFunc {

    @Param NullableFloat8Holder left;
    @Param NullableFloat8Holder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN
      if(Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = 0;
      } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
        out.value = -1;
      } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
        out.value = 1;
      } else {
        out.value = left.value < right.value ? -1 : (left.value == right.value ? 0 : 1);
      }


      } // outside
    }
  }

   @FunctionTemplate(names = {"less_than", "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanFloat8VsFloat8 implements DrillSimpleFunc {

      @Param Float8Holder left;
      @Param Float8Holder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) || ( Double.isNaN(left.value) && Double.isNaN(right.value))) {
          out.value=0;
        } else if (Double.isNaN(right.value) && !Double.isNaN(left.value)) {
          out.value = 1;
        } else {
          out.value = left.value < right.value ? 1 : 0;
        }

      }
  }

  @FunctionTemplate(names = {"less_than_or_equal_to", "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqFloat8VsFloat8 implements DrillSimpleFunc {

      @Param Float8Holder left;
      @Param Float8Holder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(right.value)){
          out.value = 1;
        } else if (!Double.isNaN(right.value) && Double.isNaN(left.value)) {
          out.value = 0;
        } else {
          out.value = left.value <= right.value ? 1 : 0;
        }

    }
  }

  @FunctionTemplate(names = {"greater_than", ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanFloat8VsFloat8 implements DrillSimpleFunc {

      @Param Float8Holder left;
      @Param Float8Holder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(right.value) || ( Double.isNaN(left.value) && Double.isNaN(right.value))) {
          out.value = 0;
        } else if (Double.isNaN(left.value) && !Double.isNaN(right.value)) {
          out.value = 1;
        } else {
          out.value = left.value > right.value ? 1 : 0;
        }

    }
  }

  @FunctionTemplate(names = {"greater_than_or_equal_to", ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqFloat8VsFloat8 implements DrillSimpleFunc {

      @Param Float8Holder left;
      @Param Float8Holder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value)){
          out.value=1;
        } else if (!Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 0;
        } else {
          out.value = left.value >= right.value ? 1 : 0;
        }


      }
  }

  @FunctionTemplate(names = {"equal", "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsFloat8VsFloat8 implements DrillSimpleFunc {

      @Param Float8Holder left;
      @Param Float8Holder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 1;
        } else {
          out.value = left.value == right.value ? 1 : 0;
        }

      }
  }

  @FunctionTemplate(names = {"not_equal", "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsFloat8VsFloat8 implements DrillSimpleFunc {

      @Param Float8Holder left;
      @Param Float8Holder right;
      @Output BitHolder out;

      public void setup() {}

      public void eval() {

        // NaN is the biggest possible value, and NaN == NaN
        if (Double.isNaN(left.value) && Double.isNaN(right.value)) {
          out.value = 0;
        } else {
          out.value = left.value != right.value ? 1 : 0;
        }

      }
  }

}


 



