

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.VarCharHolder;

import javax.inject.Inject;

/*
 * This class is generated using freemarker and the DirectoryExplorers.java template.
 */
public class DirectoryExplorers {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(DirectoryExplorers.class);



  @FunctionTemplate(name = "maxdir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class MaxDir implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            ".",
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not exist ",
                "maxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not contain sub-partitions.",
                "maxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the maximum directory in the list using a case-sensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareTo(curr) < 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "imaxdir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class IMaxDir implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            ".",
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not exist ",
                "imaxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not contain sub-partitions.",
                "imaxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the maximum directory in the list using a case-insensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareToIgnoreCase(curr) < 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "mindir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class MinDir implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            ".",
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not exist ",
                "mindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not contain sub-partitions.",
                "mindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the minimum directory in the list using a case-sensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareTo(curr) > 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "imindir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class IMinDir implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            ".",
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not exist ",
                "imindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Schema/table %s does not contain sub-partitions.",
                "imindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the minimum directory in the list using a case-insensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareToIgnoreCase(curr) > 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "maxdir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class MaxDirTwoArg implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Param  VarCharHolder table;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s does not exist in schema %s ",
                "maxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.",
                "maxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the maximum directory in the list using a case-sensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareTo(curr) < 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "imaxdir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class IMaxDirTwoArg implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Param  VarCharHolder table;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s does not exist in schema %s ",
                "imaxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.",
                "imaxdir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the maximum directory in the list using a case-insensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareToIgnoreCase(curr) < 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "mindir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class MinDirTwoArg implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Param  VarCharHolder table;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s does not exist in schema %s ",
                "mindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.",
                "mindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the minimum directory in the list using a case-sensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareTo(curr) > 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }


  @FunctionTemplate(name = "imindir", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = FunctionTemplate.NullHandling.INTERNAL)
  public static class IMinDirTwoArg implements DrillSimpleFunc {

    @Param VarCharHolder schema;
    @Param  VarCharHolder table;
    @Output VarCharHolder out;
    @Inject DrillBuf buffer;
    @Inject org.apache.drill.exec.store.PartitionExplorer partitionExplorer;

    public void setup() {
    }

    public void eval() {
      Iterable<String> subPartitions;
      try {
        subPartitions = partitionExplorer.getSubPartitions(
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema),
            org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
            new java.util.ArrayList<String>(),
            new java.util.ArrayList<String>());
      } catch (org.apache.drill.exec.store.PartitionNotFoundException e) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s does not exist in schema %s ",
                "imindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema))
        );
      }
      java.util.Iterator partitionIterator = subPartitions.iterator();
      if (!partitionIterator.hasNext()) {
        throw new RuntimeException(
            String.format("Error in %s function: Table %s in schema %s does not contain sub-partitions.",
                "imindir",
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(table),
                org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers.getStringFromVarCharHolder(schema)
            )
        );
      }
      String subPartitionStr = (String) partitionIterator.next();
      String curr;
      // find the minimum directory in the list using a case-insensitive string comparison
      while (partitionIterator.hasNext()){
        curr = (String) partitionIterator.next();
        if (subPartitionStr.compareToIgnoreCase(curr) > 0) {
          subPartitionStr = curr;
        }
      }
      String[] subPartitionParts = subPartitionStr.split("/");
      subPartitionStr = subPartitionParts[subPartitionParts.length - 1];
      byte[] result = subPartitionStr.getBytes();
      out.buffer = buffer = buffer.reallocIfNeeded(result.length);

      out.buffer.setBytes(0, subPartitionStr.getBytes(), 0, result.length);
      out.start = 0;
      out.end = result.length;
    }
  }
}
