

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/DateIntervalArithmeticFunctions.java template.
 */

public class DateIntervalFunctions {


    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class DateIntervalAddFunction implements DrillSimpleFunc {
    @Param DateHolder left;
    @Param IntervalHolder right;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output TimeStampHolder out;
        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {

    temp.setMillis(left.value);

    temp.addMonths(right.months );
    temp.addDays(right.days );
    temp.add(right.milliseconds );

    out.value = temp.getMillis();
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalDateAddFunction implements DrillSimpleFunc {

    @Param IntervalHolder right;
    @Param DateHolder left;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output TimeStampHolder out;
        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {


    temp.setMillis(left.value);

    temp.addMonths(right.months );
    temp.addDays(right.days );
    temp.add(right.milliseconds );

    out.value = temp.getMillis();
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_sub", "subtract", "date_diff"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class DateIntervalSubtractFunction implements DrillSimpleFunc {
    @Param DateHolder left;
    @Param IntervalHolder right;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output DateHolder out;

        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {

    temp.setMillis(left.value);

    temp.addMonths(right.months  * -1 );
    temp.addDays(right.days  * -1 );
    temp.add(right.milliseconds  * -1 );

    out.value = temp.getMillis();
        }
    }
}

