/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.yarn.appMaster.Dispatcher;
import org.apache.drill.yarn.appMaster.http.AMSecurityManagerImpl;
import org.apache.drill.yarn.appMaster.http.AbstractTasksModel;
import org.apache.drill.yarn.appMaster.http.AuthDynamicFeature;
import org.apache.drill.yarn.appMaster.http.ControllerModel;
import org.apache.drill.yarn.appMaster.http.PageTree;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;

public class WebUiPageTree
extends PageTree {
    public WebUiPageTree(Dispatcher dispatcher) {
        super(dispatcher);
        this.register(FreemarkerMvcFeature.class);
        this.register(RootPage.class);
        this.register(RedirectPage.class);
        this.register(ConfigPage.class);
        this.register(DrillbitsPage.class);
        this.register(CancelDrillbitPage.class);
        this.register(HistoryPage.class);
        this.register(ManagePage.class);
        this.register(ResizePage.class);
        this.register(StopPage.class);
        if (AMSecurityManagerImpl.isEnabled()) {
            this.register(LogInLogOutPages.class);
            this.register(AuthDynamicFeature.class);
            this.register(RolesAllowedDynamicFeature.class);
        }
    }

    @Path(value="/stop/")
    @RolesAllowed(value={"admin"})
    public static class StopPage {
        @Inject
        SecurityContext sc;
        @Inject
        HttpServletRequest request;

        @GET
        @Produces(value={"text/html"})
        public Viewable requestStop() {
            ConfirmShrink confirm = new ConfirmShrink(ConfirmShrink.Mode.STOP);
            return new Viewable("/drill-am/shrink-warning.ftl", PageTree.toModel(this.sc, confirm, this.request));
        }

        @POST
        @Produces(value={"text/html"})
        public Viewable doStop() {
            PageTree.dispatcher.getController().shutDown();
            Acknowledge confirm = new Acknowledge(Acknowledge.Mode.STOPPED);
            return new Viewable("/drill-am/confirm.ftl", PageTree.toModel(this.sc, confirm));
        }
    }

    @Path(value="/resize")
    @RolesAllowed(value={"admin"})
    public static class ResizePage {
        @Inject
        SecurityContext sc;
        @Inject
        HttpServletRequest request;
        @FormParam(value="n")
        int n;
        @FormParam(value="type")
        String type;

        @POST
        @Consumes(value={"application/x-www-form-urlencoded"})
        @Produces(value={"text/html"})
        public Viewable resize() {
            int newSize;
            int curSize = PageTree.dispatcher.getController().getTargetCount();
            if (this.n <= 0) {
                Acknowledge confirm = new Acknowledge(Acknowledge.Mode.INVALID_RESIZE);
                confirm.value = this.n;
                return new Viewable("/drill-am/confirm.ftl", PageTree.toModel(this.sc, confirm));
            }
            if (this.type == null) {
                this.type = "null";
            }
            boolean confirmed = false;
            if (this.type.equalsIgnoreCase("resize")) {
                newSize = this.n;
            } else if (this.type.equalsIgnoreCase("grow")) {
                newSize = curSize + this.n;
            } else if (this.type.equalsIgnoreCase("shrink")) {
                newSize = curSize - this.n;
            } else if (this.type.equalsIgnoreCase("force-shrink")) {
                newSize = curSize - this.n;
                confirmed = true;
            } else {
                Acknowledge confirm = new Acknowledge(Acknowledge.Mode.INVALID_ACTION);
                confirm.value = this.type;
                return new Viewable("/drill-am/confirm.ftl", PageTree.toModel(this.sc, confirm));
            }
            if (curSize == newSize) {
                Acknowledge confirm = new Acknowledge(Acknowledge.Mode.NULL_RESIZE);
                confirm.value = newSize;
                return new Viewable("/drill-am/confirm.ftl", PageTree.toModel(this.sc, confirm));
            }
            if (confirmed || curSize < newSize) {
                Acknowledge confirm = new Acknowledge(Acknowledge.Mode.RESIZED);
                confirm.value = PageTree.dispatcher.getController().resizeTo(newSize);
                return new Viewable("/drill-am/confirm.ftl", PageTree.toModel(this.sc, confirm));
            }
            ConfirmShrink confirm = new ConfirmShrink(ConfirmShrink.Mode.SHRINK);
            confirm.value = curSize - newSize;
            return new Viewable("/drill-am/shrink-warning.ftl", PageTree.toModel(this.sc, confirm, this.request));
        }
    }

    public static class ConfirmShrink {
        Mode mode;
        int value;
        int id;

        public ConfirmShrink(Mode mode) {
            this.mode = mode;
        }

        public boolean isStop() {
            return this.mode == Mode.STOP;
        }

        public boolean isCancel() {
            return this.mode == Mode.CANCEL;
        }

        public boolean isKill() {
            return this.mode == Mode.KILL;
        }

        public boolean isShrink() {
            return this.mode == Mode.SHRINK;
        }

        public int getCount() {
            return this.value;
        }

        public int getId() {
            return this.id;
        }

        public static enum Mode {
            SHRINK,
            STOP,
            CANCEL,
            KILL;

        }
    }

    public static class Acknowledge {
        Mode mode;
        Object value;

        public Acknowledge(Mode mode) {
            this.mode = mode;
        }

        public String getType() {
            return this.mode.toString();
        }

        public Object getValue() {
            return this.value;
        }

        public static enum Mode {
            STOPPED,
            INVALID_RESIZE,
            INVALID_ACTION,
            NULL_RESIZE,
            RESIZED,
            CANCELLED,
            INVALID_TASK;

        }
    }

    @Path(value="/manage")
    @RolesAllowed(value={"admin"})
    public static class ManagePage {
        @Inject
        SecurityContext sc;
        @Inject
        HttpServletRequest request;

        @GET
        @Produces(value={"text/html"})
        public Viewable getRoot() {
            ControllerModel model = new ControllerModel();
            PageTree.dispatcher.getController().visit(model);
            return new Viewable("/drill-am/manage.ftl", PageTree.toModel(this.sc, model, this.request));
        }
    }

    @Path(value="/history")
    @RolesAllowed(value={"admin"})
    public static class HistoryPage {
        @Inject
        SecurityContext sc;

        @GET
        @Produces(value={"text/html"})
        public Viewable getRoot() {
            AbstractTasksModel.HistoryModel model = new AbstractTasksModel.HistoryModel();
            PageTree.dispatcher.getController().visit(model);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("model", model.results);
            map.put("refreshSecs", DrillOnYarnConfig.config().getInt(DrillOnYarnConfig.HTTP_REFRESH_SECS));
            return new Viewable("/drill-am/history.ftl", PageTree.toMapModel(this.sc, map));
        }
    }

    @Path(value="/cancel/")
    @RolesAllowed(value={"admin"})
    public static class CancelDrillbitPage {
        @Inject
        private SecurityContext sc;
        @Inject
        private HttpServletRequest request;
        @QueryParam(value="id")
        private int id;

        @GET
        @Produces(value={"text/html"})
        public Viewable getPage() {
            ConfirmShrink confirm = PageTree.dispatcher.getController().isTaskLive(this.id) ? new ConfirmShrink(ConfirmShrink.Mode.KILL) : new ConfirmShrink(ConfirmShrink.Mode.CANCEL);
            confirm.id = this.id;
            return new Viewable("/drill-am/shrink-warning.ftl", PageTree.toModel(this.sc, confirm, this.request));
        }

        @POST
        @Produces(value={"text/html"})
        public Viewable postPage() {
            Acknowledge ack = PageTree.dispatcher.getController().cancelTask(this.id) ? new Acknowledge(Acknowledge.Mode.CANCELLED) : new Acknowledge(Acknowledge.Mode.INVALID_TASK);
            ack.value = this.id;
            return new Viewable("/drill-am/confirm.ftl", PageTree.toModel(this.sc, ack));
        }
    }

    @Path(value="/drillbits")
    @RolesAllowed(value={"admin"})
    public static class DrillbitsPage {
        @Inject
        private SecurityContext sc;

        @GET
        @Produces(value={"text/html"})
        public Viewable getRoot() {
            AbstractTasksModel.TasksModel model = new AbstractTasksModel.TasksModel();
            PageTree.dispatcher.getController().visitTasks(model);
            model.listAnomalies(PageTree.dispatcher.getController());
            model.sortTasks();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("model", model);
            map.put("tasks", model.getTasks());
            if (model.hasUnmanagedDrillbits()) {
                map.put("strays", model.getUnnamaged());
            }
            if (model.hasBlacklist()) {
                map.put("blacklist", model.getBlacklist());
            }
            map.put("showDisks", PageTree.dispatcher.getController().supportsDiskResource());
            map.put("refreshSecs", DrillOnYarnConfig.config().getInt(DrillOnYarnConfig.HTTP_REFRESH_SECS));
            return new Viewable("/drill-am/tasks.ftl", PageTree.toMapModel(this.sc, map));
        }
    }

    @Path(value="/config")
    @RolesAllowed(value={"admin"})
    public static class ConfigPage {
        @Inject
        private SecurityContext sc;

        @GET
        @Produces(value={"text/html"})
        public Viewable getRoot() {
            return new Viewable("/drill-am/config.ftl", PageTree.toModel(this.sc, DrillOnYarnConfig.instance().getPairs()));
        }
    }

    @Path(value="/redirect")
    @PermitAll
    public static class RedirectPage {
        @GET
        @Produces(value={"text/html"})
        public Viewable getRoot() {
            HashMap<String, String> map = new HashMap<String, String>();
            String baseUrl = DoYUtil.unwrapAmUrl(PageTree.dispatcher.getTrackingUrl());
            map.put("amLink", baseUrl);
            map.put("clusterName", PageTree.config.getString(DrillOnYarnConfig.APP_NAME));
            return new Viewable("/drill-am/redirect.ftl", map);
        }
    }

    @Path(value="/")
    @PermitAll
    public static class LogInLogOutPages {
        @Inject
        SecurityContext sc;
        public static final String REDIRECT_QUERY_PARM = "redirect";
        public static final String LOGIN_RESOURCE = "login";

        @GET
        @Path(value="/login")
        @Produces(value={"text/html"})
        public Viewable getLoginPage(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context SecurityContext sc, @Context UriInfo uriInfo, @QueryParam(value="redirect") String redirect) throws Exception {
            if (!StringUtils.isEmpty((CharSequence)redirect)) {
                HttpSession session = request.getSession(true);
                URI destURI = UriBuilder.fromUri((String)URLDecoder.decode(redirect, "UTF-8")).build(new Object[0]);
                session.setAttribute("org.eclipse.jetty.security.form_URI", (Object)destURI.getPath());
            }
            return new Viewable("/drill-am/login.ftl", PageTree.toModel(sc, null));
        }

        @POST
        @Path(value="/login")
        @Produces(value={"text/html"})
        public Viewable getLoginPageAfterValidationError() {
            return new Viewable("/drill-am/login.ftl", PageTree.toModel(this.sc, "Invalid user name or password."));
        }

        @GET
        @Path(value="/logout")
        public Viewable logout(@Context HttpServletRequest req, @Context HttpServletResponse resp) throws Exception {
            HttpSession session = req.getSession();
            if (session != null) {
                session.invalidate();
            }
            req.getRequestDispatcher("/login").forward((ServletRequest)req, (ServletResponse)resp);
            return null;
        }
    }

    @Path(value="/")
    @RolesAllowed(value={"admin"})
    public static class RootPage {
        @Inject
        SecurityContext sc;

        @GET
        @Produces(value={"text/html"})
        public Viewable getRoot() {
            ControllerModel model = new ControllerModel();
            PageTree.dispatcher.getController().visit(model);
            model.countStrayDrillbits(PageTree.dispatcher.getController());
            return new Viewable("/drill-am/index.ftl", PageTree.toModel(this.sc, model));
        }
    }
}

