/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.Records;

public class ContainerRequestSpec {
    static final Log LOG = LogFactory.getLog(ContainerRequestSpec.class);
    public int priority = 0;
    public int memoryMb;
    public int vCores = 1;
    public double disks;
    public String nodeLabelExpr;
    public List<String> racks = new ArrayList<String>();
    public List<String> hosts = new ArrayList<String>();

    public AMRMClient.ContainerRequest makeRequest() {
        assert (this.memoryMb != 0);
        Priority priorityRec = (Priority)Records.newRecord(Priority.class);
        priorityRec.setPriority(this.priority);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.memoryMb);
        capability.setVirtualCores(this.vCores);
        DoYUtil.callSetDiskIfExists(capability, this.disks);
        boolean relaxLocality = true;
        String[] nodeArr = null;
        if (!this.hosts.isEmpty()) {
            nodeArr = new String[this.hosts.size()];
            this.hosts.toArray(nodeArr);
            relaxLocality = false;
        }
        String[] rackArr = null;
        if (!this.racks.isEmpty()) {
            nodeArr = new String[this.racks.size()];
            this.racks.toArray(rackArr);
            relaxLocality = false;
        }
        String nodeExpr = null;
        if (!DoYUtil.isBlank(this.nodeLabelExpr)) {
            nodeExpr = this.nodeLabelExpr;
            LOG.info((Object)("Requesting a container using node expression: " + nodeExpr));
        }
        return new AMRMClient.ContainerRequest(capability, nodeArr, rackArr, priorityRec, relaxLocality, nodeExpr);
    }
}

