/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.zk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.work.foreman.DrillbitStatusListener;
import org.apache.drill.yarn.appMaster.AMRegistrar;
import org.apache.drill.yarn.zk.AMRegistry;
import org.apache.drill.yarn.zk.ZKClusterCoordinator;
import org.apache.drill.yarn.zk.ZKConfigException;
import org.apache.drill.yarn.zk.ZKRuntimeException;

public class ZKClusterCoordinatorDriver
implements AMRegistrar {
    private static final Pattern ZK_COMPLEX_STRING = Pattern.compile("(^.*?)/(.*)/([^/]*)$");
    private String connect = "localhost:2181";
    private String clusterId = "drillbits1";
    private String zkRoot = "drill";
    private int retryCount = 7200;
    private int connectTimeoutMs = 5000;
    private int retryDelayMs = 500;
    private int failureTimeoutMs = 120000;
    private int maxStartWaitMs = 30000;
    private int userPort = 31010;
    private int controlPort = 31011;
    private int dataPort = 31012;
    private List<CoordinationProtos.DrillbitEndpoint> initialEndpoints;
    private ConnectionStateListener stateListener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            ZKClusterCoordinatorDriver.this.stateChanged(newState);
        }
    };
    private ZKClusterCoordinator zkCoord;
    private long connectionLostTime;
    private AMRegistry amRegistry;

    public ZKClusterCoordinatorDriver setConnect(String connect) throws ZKConfigException {
        Matcher m = ZK_COMPLEX_STRING.matcher(connect);
        if (!m.matches()) {
            throw new ZKConfigException("Bad connect string: " + connect);
        }
        this.connect = m.group(1);
        this.zkRoot = m.group(2);
        this.clusterId = m.group(3);
        return this;
    }

    public ZKClusterCoordinatorDriver setConnect(String connect, String zkRoot, String clusterId) {
        this.connect = connect;
        this.zkRoot = zkRoot;
        this.clusterId = clusterId;
        return this;
    }

    public ZKClusterCoordinatorDriver setRetryCount(int n) {
        this.retryCount = n;
        return this;
    }

    public ZKClusterCoordinatorDriver setConnectTimeoutMs(int ms) {
        this.connectTimeoutMs = ms;
        return this;
    }

    public ZKClusterCoordinatorDriver setRetryDelayMs(int ms) {
        this.retryDelayMs = ms;
        return this;
    }

    public ZKClusterCoordinatorDriver setMaxStartWaitMs(int ms) {
        this.maxStartWaitMs = ms;
        return this;
    }

    public ZKClusterCoordinatorDriver setFailureTimoutMs(int ms) {
        this.failureTimeoutMs = ms;
        return this;
    }

    public ZKClusterCoordinatorDriver setPorts(int userPort, int controlPort, int dataPort) {
        this.userPort = userPort;
        this.controlPort = controlPort;
        this.dataPort = dataPort;
        return this;
    }

    public ZKClusterCoordinatorDriver build() throws ZKRuntimeException {
        try {
            this.zkCoord = new ZKClusterCoordinator(this.connect, this.zkRoot, this.clusterId, this.retryCount, this.retryDelayMs, this.connectTimeoutMs);
        }
        catch (IOException e) {
            throw new ZKRuntimeException("Failed to initialize the ZooKeeper cluster coordination", e);
        }
        try {
            this.zkCoord.start(this.maxStartWaitMs);
        }
        catch (Exception e) {
            throw new ZKRuntimeException("Failed to start the ZooKeeper cluster coordination after " + this.maxStartWaitMs + " ms.", e);
        }
        this.initialEndpoints = new ArrayList<CoordinationProtos.DrillbitEndpoint>(this.zkCoord.getAvailableEndpoints());
        this.zkCoord.getCurator().getConnectionStateListenable().addListener((Object)this.stateListener);
        this.amRegistry = new AMRegistry(this.zkCoord);
        this.amRegistry.useLocalRegistry(this.zkRoot, this.clusterId);
        return this;
    }

    public void addDrillbitListener(DrillbitStatusListener listener) {
        this.zkCoord.addDrillbitStatusListener(listener);
    }

    public void removeDrillbitListener(DrillbitStatusListener listener) {
        this.zkCoord.removeDrillbitStatusListener(listener);
    }

    public List<CoordinationProtos.DrillbitEndpoint> getInitialEndpoints() {
        return this.initialEndpoints;
    }

    public static String asString(CoordinationProtos.DrillbitEndpoint bit) {
        return ZKClusterCoordinatorDriver.formatKey(bit.getAddress(), bit.getUserPort(), bit.getControlPort(), bit.getDataPort());
    }

    public String toKey(String host) {
        return ZKClusterCoordinatorDriver.formatKey(host, this.userPort, this.controlPort, this.dataPort);
    }

    public static String formatKey(String host, int userPort, int controlPort, int dataPort) {
        StringBuilder buf = new StringBuilder();
        buf.append(host).append(":").append(userPort).append(':').append(controlPort).append(':').append(dataPort);
        return buf.toString();
    }

    protected void stateChanged(ConnectionState newState) {
        switch (newState) {
            case CONNECTED: 
            case READ_ONLY: 
            case RECONNECTED: {
                if (this.connectionLostTime != 0L) {
                    ZKClusterCoordinator.logger.info((Object)"ZK connection regained");
                }
                this.connectionLostTime = 0L;
                break;
            }
            case LOST: 
            case SUSPENDED: {
                if (this.connectionLostTime != 0L) break;
                ZKClusterCoordinator.logger.info((Object)"ZK connection lost");
                this.connectionLostTime = System.currentTimeMillis();
            }
        }
    }

    public boolean hasFailed() {
        if (this.connectionLostTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.connectionLostTime > (long)this.failureTimeoutMs;
    }

    public long getLostConnectionDurationMs() {
        if (this.connectionLostTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.connectionLostTime;
    }

    public void close() {
        if (this.zkCoord == null) {
            return;
        }
        this.zkCoord.getCurator().getConnectionStateListenable().removeListener((Object)this.stateListener);
        try {
            this.zkCoord.close();
        }
        catch (Exception e) {
            ZKClusterCoordinator.logger.error((Object)"Error occurred on ZK close, ignored", (Throwable)e);
        }
        this.zkCoord = null;
    }

    @Override
    public void register(String amHost, int amPort, String appId) throws AMRegistrar.AMRegistrationException {
        try {
            this.amRegistry.register(amHost, amPort, appId);
        }
        catch (ZKRuntimeException e) {
            throw new AMRegistrar.AMRegistrationException(e);
        }
    }

    @Override
    public void deregister() {
    }
}

