/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;

public class LaunchSpec {
    public Map<String, LocalResource> resources = new HashMap<String, LocalResource>();
    public Map<String, String> env = new HashMap<String, String>();
    public String command;
    public String mainClass;
    public List<String> classPath = new ArrayList<String>();
    public List<String> vmArgs = new ArrayList<String>();
    public List<String> cmdArgs = new ArrayList<String>();

    public String getCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.command != null) {
            cmd.add(this.command);
        } else {
            assert (this.mainClass != null);
            cmd.add(ApplicationConstants.Environment.JAVA_HOME.$$() + "/bin/java");
            cmd.addAll(this.vmArgs);
            if (!this.classPath.isEmpty()) {
                cmd.add("-cp");
                cmd.add(DoYUtil.join(":", this.classPath));
            }
            cmd.add(this.mainClass);
        }
        cmd.addAll(this.cmdArgs);
        cmd.add("1><LOG_DIR>/stdout");
        cmd.add("2><LOG_DIR>/stderr");
        return DoYUtil.join(" ", cmd);
    }

    public ContainerLaunchContext createLaunchContext(YarnConfiguration conf) throws IOException {
        ContainerLaunchContext container = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        container.setCommands(Collections.singletonList(this.getCommand()));
        container.setLocalResources(this.resources);
        container.setEnvironment(this.env);
        return container;
    }

    public void dump(PrintStream out) {
        if (this.command != null) {
            out.print("Command: ");
            out.println(this.command);
        }
        if (this.mainClass != null) {
            out.print("Main Class: ");
            out.println(this.mainClass);
            out.println("VM Args:");
            if (this.vmArgs.isEmpty()) {
                out.println("  None");
            } else {
                for (String item : this.vmArgs) {
                    out.print("  ");
                    out.println(item);
                }
            }
            out.println("Class Path:");
            if (this.classPath.isEmpty()) {
                out.println("  None");
            } else {
                for (String item : this.classPath) {
                    out.print("  ");
                    out.println(item);
                }
            }
        }
        out.println("Program Args:");
        if (this.cmdArgs.isEmpty()) {
            out.println("  None");
        } else {
            for (String item : this.cmdArgs) {
                out.print("  ");
                out.println(item);
            }
        }
        out.println("Environment:");
        if (this.env.isEmpty()) {
            out.println("  None");
        } else {
            for (String key : this.env.keySet()) {
                out.print("  ");
                out.print(key);
                out.print("=");
                out.println(this.env.get(key));
            }
        }
        out.println("Resources: ");
        if (this.resources.isEmpty()) {
            out.println("  None");
        } else {
            for (String key : this.resources.keySet()) {
                out.print("  Key: ");
                out.println(key);
                LocalResource resource = this.resources.get(key);
                out.print("   URL: ");
                out.println(resource.getResource().toString());
                out.print("   Size: ");
                out.println(resource.getSize());
                out.print("   Timestamp: ");
                out.println(DoYUtil.toIsoTime(resource.getTimestamp()));
                out.print("   Type: ");
                out.println(resource.getType().toString());
                out.print("   Visiblity: ");
                out.println(resource.getVisibility().toString());
            }
        }
    }
}

