/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AbstractScheduler;
import org.apache.drill.yarn.appMaster.Task;

public abstract class PersistentTaskScheduler
extends AbstractScheduler {
    private static final Log LOG = LogFactory.getLog(PersistentTaskScheduler.class);
    protected int quantity;

    public PersistentTaskScheduler(String type, String name, int quantity) {
        super(type, name);
        this.quantity = quantity;
    }

    @Override
    public int resize(int level) {
        this.quantity = level;
        if (this.quantity < 0) {
            this.quantity = 0;
        }
        return this.quantity;
    }

    @Override
    public int getTarget() {
        return this.quantity;
    }

    @Override
    public void completed(Task task) {
    }

    @Override
    public int[] getProgress() {
        int activeCount = this.state.getTaskCount();
        return new int[]{Math.min(activeCount, this.quantity), this.quantity};
    }

    @Override
    public void adjust() {
        int activeCount = this.state.getTaskCount();
        int delta = this.quantity - activeCount;
        if (delta > 0) {
            this.addTasks(delta);
        } else if (delta < 0) {
            this.cancelTasks(activeCount);
        }
    }

    private void cancelTasks(int cancelCount) {
        int cancelled = this.state.getCancelledTaskCount();
        int cancellable = cancelCount - cancelled;
        int n = cancellable - this.quantity;
        LOG.info((Object)("[" + this.getName() + "] - Cancelling " + cancelCount + " tasks. " + cancelled + " are already cancelled, " + cancellable + " more will be cancelled."));
        if (n <= 0) {
            return;
        }
        for (Task task : this.state.getStartingTasks()) {
            this.state.cancel(task);
            if (--n != 0) continue;
            return;
        }
        for (Task task : this.state.getActiveTasks()) {
            this.state.cancel(task);
            if (--n != 0) continue;
            return;
        }
        LOG.error((Object)("Tried to cancel " + cancellable + " tasks, but " + n + " could not be cancelled."));
        assert (false);
    }

    @Override
    public boolean hasMoreTasks() {
        return false;
    }

    @Override
    public void requestTimedOut() {
        assert (this.quantity > 0);
        if (this.quantity == 0) {
            LOG.error((Object)"Container timed out, but target quantity is already 0!");
        } else {
            --this.quantity;
            LOG.info((Object)("Container request timed out. Reducing target container count by 1 to " + this.quantity));
        }
    }
}

