/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import org.apache.drill.test.BaseTest;
import org.apache.drill.yarn.client.CommandLineOptions;
import org.junit.Assert;
import org.junit.Test;

public class TestCommandLineOptions
extends BaseTest {
    @Test
    public void testOptions() {
        CommandLineOptions opts = new CommandLineOptions();
        opts.parse(new String[0]);
        Assert.assertNull((Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"-h"});
        Assert.assertEquals((Object)CommandLineOptions.Command.HELP, (Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"-?"});
        Assert.assertEquals((Object)CommandLineOptions.Command.HELP, (Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"help"});
        Assert.assertEquals((Object)CommandLineOptions.Command.HELP, (Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"start"});
        Assert.assertEquals((Object)CommandLineOptions.Command.START, (Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"stop"});
        Assert.assertEquals((Object)CommandLineOptions.Command.STOP, (Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"status"});
        Assert.assertEquals((Object)CommandLineOptions.Command.STATUS, (Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"resize"});
        Assert.assertNull((Object)opts.getCommand());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"resize", "10"});
        Assert.assertEquals((Object)CommandLineOptions.Command.RESIZE, (Object)opts.getCommand());
        Assert.assertEquals((Object)"", (Object)opts.getResizePrefix());
        Assert.assertEquals((long)10L, (long)opts.getResizeValue());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"resize", "+2"});
        Assert.assertEquals((Object)CommandLineOptions.Command.RESIZE, (Object)opts.getCommand());
        Assert.assertEquals((Object)"+", (Object)opts.getResizePrefix());
        Assert.assertEquals((long)2L, (long)opts.getResizeValue());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"resize", "-3"});
        Assert.assertEquals((Object)CommandLineOptions.Command.RESIZE, (Object)opts.getCommand());
        Assert.assertEquals((Object)"-", (Object)opts.getResizePrefix());
        Assert.assertEquals((long)3L, (long)opts.getResizeValue());
        opts = new CommandLineOptions();
        opts.parse(new String[]{"myDrill"});
        Assert.assertNull((Object)opts.getCommand());
    }
}

