/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import com.typesafe.config.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.StatusCommand;
import org.apache.drill.yarn.core.AppSpec;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.LaunchSpec;
import org.apache.drill.yarn.core.YarnClientException;
import org.apache.drill.yarn.core.YarnRMClient;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;

public class AMRunner {
    private Config config;
    private boolean verbose;
    private ApplicationId appId;
    public Map<String, LocalResource> resources;
    public String drillArchivePath;
    public String siteArchivePath;
    public String remoteDrillHome;
    public String remoteSiteDir;
    private YarnRMClient client;
    private GetNewApplicationResponse appResponse;
    private boolean dryRun;

    public AMRunner(Config config, boolean verbose, boolean dryRun) {
        this.config = config;
        this.verbose = verbose;
        this.dryRun = dryRun;
    }

    public void run() throws ClientException {
        this.connectToYarn();
        if (this.dryRun) {
            this.doDryRun();
        } else {
            this.doLaunch();
        }
    }

    private void connectToYarn() {
        System.out.print("Loading YARN Config...");
        this.client = new YarnRMClient();
        System.out.println(" Loaded.");
    }

    private void doDryRun() throws ClientException {
        AppSpec master = this.buildSpec();
        this.dump(master, System.out);
    }

    private void doLaunch() throws ClientException {
        this.createApp();
        AppSpec master = this.buildSpec();
        if (this.verbose) {
            this.dump(master, System.out);
        }
        this.validateResources(master);
        this.launchApp(master);
        this.waitForStartAndReport(master.appName);
        this.writeAppIdFile();
    }

    private void dump(AppSpec master, PrintStream out) {
        out.println("----------------------------------------------");
        out.println("Application Master Launch Spec");
        master.dump(out);
        out.println("----------------------------------------------");
    }

    private AppSpec buildSpec() throws ClientException {
        AppSpec master = new AppSpec();
        String heapMem = this.config.getString(DrillOnYarnConfig.AM_HEAP);
        master.env.put("DRILL_AM_HEAP", heapMem);
        this.addIfSet(master, DrillOnYarnConfig.AM_VM_ARGS, "DRILL_AM_JAVA_OPTS");
        this.addIfSet(master, DrillOnYarnConfig.AM_PREFIX_CLASSPATH, "DRILL_CLASSPATH_PREFIX");
        this.addIfSet(master, DrillOnYarnConfig.AM_CLASSPATH, "DRILL_CLASSPATH");
        this.addIfSet(master, DrillOnYarnConfig.JAVA_LIB_PATH, "DOY_JAVA_LIB_PATH");
        if (!this.config.getBoolean(DrillOnYarnConfig.DISABLE_YARN_LOGS)) {
            master.env.put("DRILL_YARN_LOG_DIR", "<LOG_DIR>");
        }
        master.command = this.remoteDrillHome + "/bin/drill-am.sh";
        if (this.remoteSiteDir != null) {
            master.cmdArgs.add("--site");
            master.cmdArgs.add(this.remoteSiteDir);
        }
        String appIdStr = this.dryRun ? "Unknown" : this.appId.toString();
        master.env.put("DRILL_AM_APP_ID", appIdStr);
        if (this.config.getBoolean(DrillOnYarnConfig.AM_DEBUG_LAUNCH)) {
            master.env.put("DRILL_DEBUG", "1");
        }
        if (this.config.getBoolean(DrillOnYarnConfig.LOCALIZE_DRILL)) {
            master.env.put("DRILL_ARCHIVE", this.drillArchivePath);
            if (this.siteArchivePath != null) {
                master.env.put("SITE_ARCHIVE", this.siteArchivePath);
            }
        }
        master.resources.putAll(this.resources);
        master.memoryMb = this.config.getInt(DrillOnYarnConfig.AM_MEMORY);
        master.vCores = this.config.getInt(DrillOnYarnConfig.AM_VCORES);
        master.disks = this.config.getDouble(DrillOnYarnConfig.AM_DISKS);
        master.appName = this.config.getString(DrillOnYarnConfig.APP_NAME);
        master.queueName = this.config.getString(DrillOnYarnConfig.YARN_QUEUE);
        master.priority = this.config.getInt(DrillOnYarnConfig.YARN_PRIORITY);
        master.nodeLabelExpr = this.config.getString(DrillOnYarnConfig.AM_NODE_LABEL_EXPR);
        return master;
    }

    private void addIfSet(LaunchSpec spec, String configParam, String envVar) {
        String value = this.config.getString(configParam);
        if (!DoYUtil.isBlank(value)) {
            spec.env.put(envVar, value);
        }
    }

    private void createApp() throws ClientException {
        try {
            this.appResponse = this.client.createAppMaster();
        }
        catch (YarnClientException e) {
            throw new ClientException("Failed to allocate Drill application master", e);
        }
        this.appId = this.appResponse.getApplicationId();
        System.out.println("Application ID: " + this.appId.toString());
    }

    private void validateResources(AppSpec master) throws ClientException {
        int maxMemory = this.appResponse.getMaximumResourceCapability().getMemory();
        int maxCores = this.appResponse.getMaximumResourceCapability().getVirtualCores();
        if (this.verbose) {
            System.out.println("Max Memory: " + maxMemory);
            System.out.println("Max Cores: " + maxCores);
        }
        if (master.memoryMb > maxMemory) {
            throw new ClientException("YARN maximum memory is " + maxMemory + " but the application master requests " + master.memoryMb);
        }
        if (master.vCores > maxCores) {
            throw new ClientException("YARN maximum vcores is " + maxCores + " but the application master requests " + master.vCores);
        }
        if (this.config.getInt(DrillOnYarnConfig.DRILLBIT_MEMORY) > maxMemory) {
            throw new ClientException("YARN maximum memory is " + maxMemory + " but the Drillbit requests " + this.config.getInt(DrillOnYarnConfig.DRILLBIT_MEMORY));
        }
        if (this.config.getInt(DrillOnYarnConfig.DRILLBIT_VCORES) > maxCores) {
            throw new ClientException("YARN maximum vcores is " + maxCores + " but the Drillbit requests " + this.config.getInt(DrillOnYarnConfig.DRILLBIT_VCORES));
        }
    }

    private void launchApp(AppSpec master) throws ClientException {
        try {
            this.client.submitAppMaster(master);
        }
        catch (YarnClientException e) {
            throw new ClientException("Failed to start Drill application master", e);
        }
    }

    private void writeAppIdFile() throws ClientException {
        File appIdFile = ClientCommand.getAppIdFile();
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(appIdFile));
            writer.println(this.appId);
            writer.close();
        }
        catch (IOException e) {
            throw new ClientException("Failed to write appid file: " + appIdFile.getAbsolutePath());
        }
    }

    private void waitForStartAndReport(String appName) throws ClientException {
        StartMonitor monitor = new StartMonitor();
        monitor.run(appName);
    }

    private class StartMonitor {
        StatusCommand.Reporter reporter;
        private YarnApplicationState state;
        private int pollWaitSec;
        private int startupWaitSec;

        public StartMonitor() {
            this.pollWaitSec = AMRunner.this.config.getInt(DrillOnYarnConfig.CLIENT_POLL_SEC);
            if (this.pollWaitSec < 1) {
                this.pollWaitSec = 1;
            }
            this.startupWaitSec = AMRunner.this.config.getInt(DrillOnYarnConfig.CLIENT_START_WAIT_SEC);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(String appName) throws ClientException {
            System.out.print("Launching " + appName + "...");
            this.reporter = new StatusCommand.Reporter(AMRunner.this.client);
            this.reporter.getReport();
            if (!this.reporter.isStarting()) {
                return;
            }
            this.updateState(this.reporter.getState());
            try {
                int attemptCount = this.startupWaitSec / this.pollWaitSec;
                for (int attempt = 0; attempt < attemptCount; ++attempt) {
                    if (this.poll()) continue;
                    break;
                }
            }
            finally {
                System.out.println();
            }
            this.reporter.display(AMRunner.this.verbose, true);
            if (this.reporter.isStarting()) {
                System.out.println("Application Master is slow to start, use the 'status' command later to check status.");
            }
        }

        private boolean poll() throws ClientException {
            try {
                Thread.sleep(this.pollWaitSec * 1000);
            }
            catch (InterruptedException e) {
                return false;
            }
            this.reporter.getReport();
            if (!this.reporter.isStarting()) {
                return false;
            }
            YarnApplicationState newState = this.reporter.getState();
            if (newState == this.state) {
                System.out.print(".");
                return true;
            }
            System.out.println();
            this.updateState(newState);
            return true;
        }

        private void updateState(YarnApplicationState newState) {
            this.state = newState;
            if (AMRunner.this.verbose) {
                System.out.print("Application State: ");
                System.out.println(this.state.toString());
                System.out.print("Starting...");
            }
        }
    }
}

