/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class DfsFacade {
    private FileSystem fs;
    private Configuration yarnConf;
    private Config config;
    private boolean localize;

    public DfsFacade(Config config) {
        this.config = config;
        this.localize = config.getBoolean(DrillOnYarnConfig.LOCALIZE_DRILL);
    }

    public boolean isLocalized() {
        return this.localize;
    }

    public void connect() throws DfsFacadeException {
        block5: {
            this.loadYarnConfig();
            String dfsConnection = this.config.getString(DrillOnYarnConfig.DFS_CONNECTION);
            try {
                URI uri;
                if (DoYUtil.isBlank(dfsConnection)) {
                    this.fs = FileSystem.get((Configuration)this.yarnConf);
                    break block5;
                }
                try {
                    uri = new URI(dfsConnection);
                }
                catch (URISyntaxException e) {
                    throw new DfsFacadeException("Illformed DFS connection: " + dfsConnection, e);
                }
                this.fs = FileSystem.get((URI)uri, (Configuration)this.yarnConf);
            }
            catch (IOException e) {
                throw new DfsFacadeException("Failed to create the DFS", e);
            }
        }
    }

    private void loadYarnConfig() {
        if (this.yarnConf == null) {
            this.yarnConf = new YarnConfiguration();
            URI fsUri = FileSystem.getDefaultUri((Configuration)this.yarnConf);
            if (fsUri.toString().startsWith("file:/")) {
                System.err.println("Warning: Default DFS URI is for a local file system: " + fsUri);
            }
        }
    }

    public boolean exists(Path path) throws IOException {
        return this.fs.exists(path);
    }

    public Path getUploadPath(File localArchiveFile) {
        return this.getUploadPath(localArchiveFile.getName());
    }

    public Path getUploadPath(String baseName) {
        Path appDir;
        String dfsDirStr = this.config.getString(DrillOnYarnConfig.DFS_APP_DIR);
        if (dfsDirStr.startsWith("/")) {
            appDir = new Path(dfsDirStr);
        } else {
            Path home = this.fs.getHomeDirectory();
            appDir = new Path(home, dfsDirStr);
        }
        return new Path(appDir, baseName);
    }

    public void uploadArchive(File localArchiveFile, Path destPath, String label) throws DfsFacadeException {
        String dfsDirStr = this.config.getString(DrillOnYarnConfig.DFS_APP_DIR);
        Path appDir = new Path(dfsDirStr);
        try {
            if (!this.fs.isDirectory(appDir)) {
                this.fs.mkdirs(appDir, new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE));
            }
        }
        catch (IOException e) {
            throw new DfsFacadeException("Failed to create DFS directory: " + dfsDirStr, e);
        }
        String baseName = localArchiveFile.getName();
        if (DrillOnYarnConfig.findSuffix(baseName) == null) {
            throw new DfsFacadeException(label + " archive must be .tar.gz, .tgz or .zip: " + baseName);
        }
        Path srcPath = new Path(localArchiveFile.getAbsolutePath());
        try {
            this.fs.copyFromLocalFile(false, true, srcPath, destPath);
        }
        catch (IOException e) {
            throw new DfsFacadeException("Failed to upload " + label + " archive to DFS: " + localArchiveFile.getAbsolutePath() + " --> " + destPath, e);
        }
    }

    private FileStatus getFileStatus(Path dfsPath) throws DfsFacadeException {
        try {
            return this.fs.getFileStatus(dfsPath);
        }
        catch (IOException e) {
            throw new DfsFacadeException("Failed to get DFS status for file: " + dfsPath, e);
        }
    }

    public LocalResource makeResource(Path dfsPath, FileStatus dfsFileStatus, LocalResourceType type, LocalResourceVisibility visibility) throws DfsFacadeException {
        URL destUrl;
        try {
            destUrl = ConverterUtils.getYarnUrlFromPath((Path)FileContext.getFileContext().makeQualified(dfsPath));
        }
        catch (UnsupportedFileSystemException e) {
            throw new DfsFacadeException("Unable to convert dfs file to a URL: " + dfsPath.toString(), (Exception)((Object)e));
        }
        LocalResource resource = LocalResource.newInstance((URL)destUrl, (LocalResourceType)type, (LocalResourceVisibility)visibility, (long)dfsFileStatus.getLen(), (long)dfsFileStatus.getModificationTime());
        return resource;
    }

    public void removeDrillFile(String fileName) throws DfsFacadeException {
        Path destPath = this.getUploadPath(fileName);
        try {
            this.fs.delete(destPath, false);
        }
        catch (IOException e) {
            throw new DfsFacadeException("Failed to delete file: " + destPath.toString(), e);
        }
        Path dir = destPath.getParent();
        try {
            RemoteIterator iter = this.fs.listStatusIterator(dir);
            if (!iter.hasNext()) {
                this.fs.delete(dir, false);
            }
        }
        catch (IOException e) {
            throw new DfsFacadeException("Failed to delete directory: " + dir.toString(), e);
        }
    }

    public static class Localizer {
        private final DfsFacade dfs;
        protected File localArchivePath;
        protected Path dfsArchivePath;
        FileStatus fileStatus;
        private String label;

        public Localizer(DfsFacade dfs, File archivePath, String label) {
            this(dfs, archivePath, dfs.getUploadPath(archivePath), label);
        }

        public Localizer(DfsFacade dfs, File archivePath, String destName, String label) {
            this(dfs, archivePath, dfs.getUploadPath(destName), label);
        }

        public Localizer(DfsFacade dfs, String destPath) {
            this(dfs, null, new Path(destPath), null);
        }

        public Localizer(DfsFacade dfs, File archivePath, Path destPath, String label) {
            this.dfs = dfs;
            this.dfsArchivePath = destPath;
            this.label = label;
            this.localArchivePath = archivePath;
        }

        public String getBaseName() {
            return this.localArchivePath.getName();
        }

        public String getDestPath() {
            return this.dfsArchivePath.toString();
        }

        public void upload() throws DfsFacadeException {
            this.dfs.uploadArchive(this.localArchivePath, this.dfsArchivePath, this.label);
            this.fileStatus = null;
        }

        private FileStatus getStatus() throws DfsFacadeException {
            if (this.fileStatus == null) {
                this.fileStatus = this.dfs.getFileStatus(this.dfsArchivePath);
            }
            return this.fileStatus;
        }

        public void defineResources(Map<String, LocalResource> resources, String key) throws DfsFacadeException {
            LocalResource drillResource = this.dfs.makeResource(this.dfsArchivePath, this.getStatus(), LocalResourceType.ARCHIVE, LocalResourceVisibility.APPLICATION);
            resources.put(key, drillResource);
        }

        public boolean filesMatch() {
            FileStatus status;
            try {
                status = this.getStatus();
            }
            catch (DfsFacadeException e) {
                return false;
            }
            return status.getLen() == this.localArchivePath.length();
        }

        public String getLabel() {
            return this.label;
        }

        public boolean destExists() throws IOException {
            return this.dfs.exists(this.dfsArchivePath);
        }
    }

    public static class DfsFacadeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DfsFacadeException(String msg) {
            super(msg);
        }

        public DfsFacadeException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

