/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.scripts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public class ScriptUtils {
    private static ScriptUtils instance = new ScriptUtils();
    public File distribDir;
    public File javaHome;
    public File testDir;
    public File testDrillHome;
    public File testSiteDir;
    public File testLogDir;
    public boolean externalLogDir;
    public static String[] sqlLineArgs = ScriptUtils.makeSqlLineArgs();
    public static final boolean USE_SOURCE = true;
    public static final String TEMP_DIR = "/tmp";
    public static boolean useSource = true;
    public static String[] stdArgs = ScriptUtils.buildStdArgs();
    static String[] stdCp = new String[]{"conf", "jars/*", "jars/ext/*", "jars/3rdparty/*", "jars/classb/*"};
    static String[] distribDirs = new String[]{"bin", "jars", "jars/3rdparty", "jars/ext", "conf"};
    static String[] jarDirs = new String[]{"jars", "jars/3rdparty", "jars/ext"};
    public static String[] scripts = new String[]{"drill-config.sh", "drill-embedded", "drill-localhost", "drill-on-yarn.sh", "drillbit.sh", "drill-conf", "runbit", "sqlline", "yarn-drillbit.sh", "auto-setup.sh"};

    private static String[] makeSqlLineArgs() {
        String[] args = new String[]{"-Dlog.path=/.*/drill/log/sqlline\\.log", "-Dlog.query.path=/.*/drill/log/sqlline_queries\\.json", "sqlline\\.SqlLine", "-d", "org\\.apache\\.drill\\.jdbc\\.Driver", "--maxWidth=10000", "--color=true"};
        if (new File("/var/log/drill").exists()) {
            args[0] = "-Dlog\\.path=/var/log/drill/sqlline\\.log";
            args[1] = "-Dlog\\.query\\.path=/var/log/drill/sqlline_queries\\.json";
        }
        return args;
    }

    private ScriptUtils() {
        String drillScriptsDir = System.getProperty("drillScriptDir");
        Assert.assertNotNull((Object)drillScriptsDir);
        this.distribDir = new File(drillScriptsDir);
        this.javaHome = new File(System.getProperty("java.home"));
    }

    public static ScriptUtils instance() {
        return instance;
    }

    public ScriptUtils fromSource(String sourceDir) {
        useSource = true;
        return this;
    }

    public ScriptUtils fromDistrib(String distrib) {
        this.distribDir = new File(distrib);
        useSource = false;
        return this;
    }

    private static String[] buildStdArgs() {
        String[] args = new String[]{"-Xms4G", "-Xmx4G", "-XX:MaxDirectMemorySize=8G", "-XX:ReservedCodeCacheSize=1G", "-Ddrill\\.exec\\.enable-epoll=false", "-XX:\\+UseG1GC", "org\\.apache\\.drill\\.exec\\.server\\.Drillbit", "-Dlog\\.path=/.*/script-test/drill/log/drillbit\\.log", "-Dlog\\.query\\.path=/.*/script-test/drill/log/drillbit_queries\\.json"};
        if (new File("/var/log/drill").exists()) {
            args[args.length - 2] = "-Dlog\\.path=/var/log/drill/drillbit\\.log";
            args[args.length - 1] = "-Dlog\\.query\\.path=/var/log/drill/drillbit_queries\\.json";
        }
        return args;
    }

    public void initialSetup() throws IOException {
        File tempDir = new File(TEMP_DIR);
        this.testDir = new File(tempDir, "script-test");
        this.testDrillHome = new File(this.testDir, "drill");
        this.testSiteDir = new File(this.testDir, "site");
        File varLogDrill = new File("/var/log/drill");
        if (varLogDrill.exists()) {
            this.testLogDir = varLogDrill;
            this.externalLogDir = true;
        } else {
            this.testLogDir = new File(this.testDrillHome, "log");
        }
        if (this.testDir.exists()) {
            FileUtils.forceDelete((File)this.testDir);
        }
        this.testDir.mkdirs();
        this.testSiteDir.mkdir();
        this.testLogDir.mkdir();
    }

    public void createMockDistrib() throws IOException {
        if (useSource) {
            this.buildFromSource();
        } else {
            this.buildFromDistrib();
        }
    }

    private void buildFromSource() throws IOException {
        this.createMockDirs();
        this.copyScripts(ScriptUtils.instance().distribDir);
    }

    private void createMockDirs() throws IOException {
        if (this.testDrillHome.exists()) {
            FileUtils.forceDelete((File)this.testDrillHome);
        }
        this.testDrillHome.mkdir();
        for (String path : distribDirs) {
            File subDir = new File(this.testDrillHome, path);
            subDir.mkdirs();
        }
        for (String path : jarDirs) {
            this.makeDummyJar(new File(this.testDrillHome, path), "dist");
        }
    }

    public File makeDummyJar(File dir, String prefix) throws IOException {
        String jarName = "";
        if (prefix != null) {
            jarName = jarName + prefix + "-";
        }
        jarName = jarName + dir.getName() + ".jar";
        File jarFile = new File(dir, jarName);
        this.writeFile(jarFile, "Dummy jar");
        return jarFile;
    }

    public void writeFile(File file, String contents) throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            out.println(contents);
        }
    }

    public void writeEnvFile(PrintWriter out, String key, String value, boolean overrideValue) {
        out.print("export ");
        out.print(key);
        out.print("=");
        if (!overrideValue) {
            out.print("${");
            out.print(key);
            out.print(":-");
        }
        out.print("\"");
        out.print(value);
        out.print("\"");
        if (!overrideValue) {
            out.print("}");
        }
        out.println();
    }

    public void createEnvFile(File file, Map<String, String> env, boolean overrideValue) throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            out.println("#!/bin/bash");
            for (String key : env.keySet()) {
                String value = env.get(key);
                this.writeEnvFile(out, key, value, overrideValue);
            }
        }
    }

    public void createEnvFileWithCondition(File file, Map<String, String> condition, Map<String, String> env, boolean overrideValue) throws IOException {
        if (env.size() == 0 || condition.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, String>> envIterator = env.entrySet().iterator();
        Map.Entry<String, String> currentEnv = envIterator.next();
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            out.println("#!/bin/bash");
            for (String condKey : condition.keySet()) {
                String condValue = condition.get(condKey);
                out.print("if [ \"$");
                out.print(condKey);
                out.print("\" = \"");
                out.print(condValue);
                out.println("\" ]; then");
                String envKey = currentEnv.getKey().toString();
                String envValue = currentEnv.getValue().toString();
                this.writeEnvFile(out, envKey, envValue, overrideValue);
                out.println("fi");
                out.println();
                if (!envIterator.hasNext()) continue;
                currentEnv = envIterator.next();
            }
        }
    }

    private void copyScripts(File sourceDir) throws IOException {
        File binDir = new File(this.testDrillHome, "bin");
        for (String script : scripts) {
            File source = new File(sourceDir, script);
            File dest = new File(binDir, script);
            this.copyFile(source, dest);
            dest.setExecutable(true);
        }
        String wrapper = "wrapper.sh";
        File dest = new File(binDir, wrapper);
        try (InputStream is = this.getClass().getResourceAsStream("/" + wrapper);){
            Files.copy(is, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        dest.setExecutable(true);
    }

    private void buildFromDistrib() {
    }

    public void createMockConf(File siteDir) throws IOException {
        this.createDir(siteDir);
        File override = new File(siteDir, "drill-override.conf");
        this.writeFile(override, "# Dummy override");
    }

    public void removeDir(File dir) throws IOException {
        if (dir.exists()) {
            FileUtils.forceDelete((File)dir);
        }
    }

    public File createDir(File dir) throws IOException {
        this.removeDir(dir);
        dir.mkdirs();
        return dir;
    }

    public void copyFile(File source, File dest) throws IOException {
        Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static class DrillbitRun
    extends ScriptRunner {
        public File pidDir;

        public DrillbitRun() {
            super("drillbit.sh");
        }

        public DrillbitRun(String cmd) {
            super("drillbit.sh", cmd);
        }

        public DrillbitRun withPidDir(File pidDir) {
            this.pidDir = pidDir;
            return this;
        }

        public DrillbitRun asDaemon() {
            this.addEnv("KEEP_RUNNING", "1");
            return this;
        }

        public RunResult start() throws IOException {
            if (this.pidDir == null) {
                this.pidDir = this.drillHome;
            }
            this.pidFile = new File(this.pidDir, "drillbit.pid");
            this.asDaemon();
            RunResult result = this.run();
            if (result.returnCode == 0) {
                this.capturePidFile(result);
                this.captureDrillOut(result);
            }
            return result;
        }

        private void capturePidFile(RunResult result) {
            Assert.assertTrue((boolean)this.pidFile.exists());
            result.pidFile = this.pidFile;
        }

        private void captureDrillOut(RunResult result) throws IOException {
            result.outFile = new File(result.logDir, "drillbit.out");
            if (result.outFile.exists()) {
                result.loadOut();
            } else {
                result.outFile = null;
            }
        }
    }

    public static class ScriptRunner {
        public static String DRILLBIT_RUN = "run";
        public static String DRILLBIT_START = "start";
        public static String DRILLBIT_STATUS = "status";
        public static String DRILLBIT_STOP = "stop";
        public static String DRILLBIT_RESTART = "restart";
        public File cwd;
        public File drillHome;
        public String script;
        public List<String> args;
        public Map<String, String> env;
        public File logDir;
        public File pidFile;
        public File outputFile;
        public boolean preserveLogs;

        public ScriptRunner(String script) {
            this.cwd = instance.testDir;
            this.drillHome = instance.testDrillHome;
            this.args = new ArrayList<String>();
            this.env = new HashMap<String, String>();
            this.script = script;
        }

        public ScriptRunner(String script, String cmd) {
            this(script);
            this.args.add(cmd);
        }

        public ScriptRunner(String script, String[] cmdArgs) {
            this(script);
            for (String arg : cmdArgs) {
                this.args.add(arg);
            }
        }

        public ScriptRunner withArg(String arg) {
            this.args.add(arg);
            return this;
        }

        public ScriptRunner withSite(File siteDir) {
            if (siteDir != null) {
                this.args.add("--site");
                this.args.add(siteDir.getAbsolutePath());
            }
            return this;
        }

        public ScriptRunner withEnvironment(Map<String, String> env) {
            if (env != null) {
                this.env.putAll(env);
            }
            return this;
        }

        public ScriptRunner addEnv(String key, String value) {
            this.env.put(key, value);
            return this;
        }

        public ScriptRunner withLogDir(File logDir) {
            this.logDir = logDir;
            return this;
        }

        public ScriptRunner preserveLogs() {
            this.preserveLogs = true;
            return this;
        }

        public RunResult run() throws IOException {
            File binDir = new File(this.drillHome, "bin");
            File scriptFile = new File(binDir, this.script);
            Assert.assertTrue((boolean)scriptFile.exists());
            this.outputFile = new File(instance.testDir, "output.txt");
            this.outputFile.delete();
            if (this.logDir == null) {
                this.logDir = instance.testLogDir;
            }
            if (!this.preserveLogs) {
                this.cleanLogs(this.logDir);
            }
            Process proc = this.startProcess(scriptFile);
            RunResult result = this.runProcess(proc);
            if (result.returnCode == 0) {
                this.captureOutput(result);
                this.captureLog(result);
            }
            return result;
        }

        private void cleanLogs(File logDir) throws IOException {
            if (logDir == instance.testLogDir && instance.externalLogDir) {
                return;
            }
            if (logDir.exists()) {
                FileUtils.forceDelete((File)logDir);
            }
        }

        private Process startProcess(File scriptFile) throws IOException {
            this.outputFile.delete();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(scriptFile.getAbsolutePath());
            cmd.addAll(this.args);
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(cmd).directory(this.cwd);
            Map<String, String> pbEnv = pb.environment();
            pbEnv.clear();
            pbEnv.putAll(this.env);
            File binDir = new File(this.drillHome, "bin");
            File wrapperCmd = new File(binDir, "wrapper.sh");
            pbEnv.put("_DRILL_WRAPPER_", wrapperCmd.getAbsolutePath());
            pbEnv.put("JAVA_HOME", instance.javaHome.getAbsolutePath());
            return pb.start();
        }

        private RunResult runProcess(Process proc) {
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
            outputGobbler.start();
            errorGobbler.start();
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RunResult result = new RunResult();
            result.stderr = errorGobbler.buf.toString();
            result.stdout = outputGobbler.buf.toString();
            result.returnCode = proc.exitValue();
            return result;
        }

        private void captureOutput(RunResult result) throws IOException {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.outputFile));){
                String line;
                result.echoArgs = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    result.echoArgs.add(line);
                }
                result.analyze();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        private void captureLog(RunResult result) throws IOException {
            result.logDir = this.logDir;
            result.logFile = new File(this.logDir, "drillbit.log");
            if (result.logFile.exists()) {
                result.loadLog();
            } else {
                result.logFile = null;
            }
        }
    }

    public static class RunResult {
        File logDir;
        File logFile;
        String stdout;
        String stderr;
        List<String> echoArgs;
        int returnCode;
        String[] classPath;
        String[] libPath;
        String log;
        public File pidFile;
        public File outFile;
        String out;

        public void analyze() {
            if (this.echoArgs == null) {
                return;
            }
            for (int i = 0; i < this.echoArgs.size(); ++i) {
                String arg = this.echoArgs.get(i);
                if (!arg.equals("-cp")) continue;
                this.classPath = Pattern.compile(":").split(this.echoArgs.get(i + 1));
                break;
            }
            String probe = "-Djava.library.path=";
            for (int i = 0; i < this.echoArgs.size(); ++i) {
                String arg = this.echoArgs.get(i);
                if (!arg.startsWith(probe)) continue;
                Assert.assertNull((Object)this.libPath);
                this.libPath = Pattern.compile(":").split(arg.substring(probe.length()));
                break;
            }
        }

        public void loadLog() throws IOException {
            this.log = this.loadFile(this.logFile);
        }

        private String loadFile(File file) throws IOException {
            String string;
            StringBuilder buf = new StringBuilder();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    buf.append(line);
                    buf.append("\n");
                }
                string = buf.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            reader.close();
            return string;
        }

        public void validateJava() {
            Assert.assertNotNull(this.echoArgs);
            String java = instance.javaHome + "/bin/java";
            List<String> actual = this.echoArgs;
            Assert.assertEquals((Object)java, (Object)actual.get(0));
        }

        public boolean containsArg(String arg) {
            for (String actual : this.echoArgs) {
                if (!actual.equals(arg)) continue;
                return true;
            }
            return false;
        }

        public void validateStockArgs() {
            for (String arg : stdArgs) {
                Assert.assertTrue((String)("Argument not found: " + arg + " in " + this.echoArgs), (boolean)this.containsArgRegex(arg));
            }
        }

        public void validateArg(String arg) {
            this.validateArgs(Collections.singletonList(arg));
        }

        public void validateArgs(String[] args) {
            this.validateArgs(Arrays.asList(args));
        }

        public void validateArgs(List<String> args) {
            this.validateJava();
            for (String arg : args) {
                Assert.assertTrue((boolean)this.containsArg(arg));
            }
        }

        public void validateArgRegex(String arg) {
            Assert.assertTrue((boolean)this.containsArgRegex(arg));
        }

        public void validateArgsRegex(List<String> args) {
            Assert.assertTrue((boolean)this.containsArgsRegex(args));
        }

        public boolean containsArgsRegex(List<String> args) {
            for (String arg : args) {
                if (this.containsArgRegex(arg)) continue;
                return false;
            }
            return true;
        }

        public boolean containsArgsRegex(String[] args) {
            for (String arg : args) {
                if (this.containsArgRegex(arg)) continue;
                return false;
            }
            return true;
        }

        public boolean containsArgRegex(String arg) {
            for (String actual : this.echoArgs) {
                if (!actual.matches(arg)) continue;
                return true;
            }
            return false;
        }

        public void validateClassPath(String expectedCP) {
            Assert.assertTrue((boolean)this.classPathContains(expectedCP));
        }

        public void validateClassPath(String[] expectedCP) {
            Assert.assertTrue((boolean)this.classPathContains(expectedCP));
        }

        public boolean classPathContains(String[] expectedCP) {
            for (String entry : expectedCP) {
                if (this.classPathContains(entry)) continue;
                return false;
            }
            return true;
        }

        public boolean classPathContains(String expectedCP) {
            if (this.classPath == null) {
                Assert.fail((String)"No classpath returned");
            }
            String tail = "/" + instance.testDir.getName() + "/" + instance.testDrillHome.getName() + "/";
            String expectedPath = expectedCP.startsWith("/") ? expectedCP : tail + expectedCP;
            for (String entry : this.classPath) {
                if (!entry.endsWith(expectedPath)) continue;
                return true;
            }
            return false;
        }

        public void loadOut() throws IOException {
            this.out = this.loadFile(this.outFile);
        }

        public void validateDrillLog() {
            Assert.assertNotNull((Object)this.log);
            Assert.assertTrue((boolean)this.log.contains("Drill Log Message"));
        }

        public void validateStdOut() {
            Assert.assertTrue((boolean)this.stdout.contains("Starting drillbit on"));
        }

        public void validateStdErr() {
            Assert.assertTrue((boolean)this.stderr.contains("Stderr Message"));
        }

        public int getPid() throws IOException {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.pidFile));){
                int n = Integer.parseInt(reader.readLine());
                return n;
            }
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        public StringBuilder buf = new StringBuilder();

        private StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.buf.append(line);
                    this.buf.append("\n");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

