/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.scanner.persistence;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.scanner.persistence.AnnotationDescriptor;
import org.apache.drill.common.scanner.persistence.TypeDescriptor;

public final class FieldDescriptor {
    private final String name;
    private final String descriptor;
    private final List<AnnotationDescriptor> annotations;
    private final Map<String, AnnotationDescriptor> annotationMap;

    @JsonCreator
    public FieldDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="descriptor") String descriptor, @JsonProperty(value="annotations") List<AnnotationDescriptor> annotations) {
        this.name = name;
        this.descriptor = descriptor;
        this.annotations = annotations;
        this.annotationMap = AnnotationDescriptor.buildAnnotationsMap(annotations);
        this.getType();
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations;
    }

    public AnnotationDescriptor getAnnotation(Class<?> clazz) {
        return this.annotationMap.get(clazz.getName());
    }

    public <T> T getAnnotationProxy(Class<T> clazz) {
        AnnotationDescriptor annotationDescriptor = this.getAnnotation(clazz);
        if (annotationDescriptor == null) {
            return null;
        }
        return annotationDescriptor.getProxy(clazz);
    }

    @JsonIgnore
    public TypeDescriptor getType() {
        char c;
        int arrayDim = 0;
        while ((c = this.descriptor.charAt(arrayDim)) == '[') {
            ++arrayDim;
        }
        if (c == 'L') {
            int lastIndex = this.descriptor.length() - 1;
            if (this.descriptor.charAt(lastIndex) != ';') {
                throw new DrillRuntimeException("Illegal descriptor: " + this.descriptor);
            }
            String className = this.descriptor.substring(arrayDim + 1, lastIndex).replace('/', '.');
            return TypeDescriptor.forClass(className, arrayDim);
        }
        return TypeDescriptor.forPrimitive(c, arrayDim);
    }

    @JsonIgnore
    public Class<?> getFieldClass() {
        TypeDescriptor type = this.getType();
        Class<?> elementClass = type.getType();
        if (type.isArray()) {
            return Array.newInstance(elementClass, new int[type.getArrayDim()]).getClass();
        }
        return elementClass;
    }

    public String toString() {
        return "Field[name=" + this.name + ", descriptor=" + this.descriptor + ", annotations=" + this.annotations + "]";
    }
}

