/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.map;

import java.util.HashMap;
import java.util.Set;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.junit.Assert;
import org.junit.Test;

public class TestCaseInsensitiveMap {
    @Test
    public void putAndGet() {
        CaseInsensitiveMap map = CaseInsensitiveMap.newConcurrentMap();
        Assert.assertTrue((boolean)map.isEmpty());
        map.put("DRILL", (Object)1);
        map.put("bABy", (Object)2);
        map.put("drill!", (Object)3);
        Assert.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey((Object)"drill"));
        Assert.assertEquals((long)2L, (long)((Integer)map.get((Object)"BabY")).intValue());
        Assert.assertNull((Object)map.get((Object)2));
        Assert.assertEquals((long)3L, (long)((Integer)map.remove((Object)"DriLl!")).intValue());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsValue((Object)1));
    }

    @Test
    public void addAllFromAnother() {
        HashMap<String, Integer> another = new HashMap<String, Integer>();
        another.put("JuSt", 1);
        another.put("DRILL", 2);
        another.put("it", 3);
        CaseInsensitiveMap map = CaseInsensitiveMap.newConcurrentMap();
        map.putAll(another);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("just"));
        Assert.assertEquals((long)2L, (long)((Integer)map.get("drill")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)map.remove("IT")).intValue());
        Set entrySet = map.entrySet();
        Assert.assertEquals((long)2L, (long)entrySet.size());
    }

    @Test
    public void checkEquals() {
        CaseInsensitiveMap map1 = CaseInsensitiveMap.newHashMap();
        map1.put("key_1", "value_1");
        CaseInsensitiveMap map2 = CaseInsensitiveMap.newHashMap();
        map2.put("KEY_1", "value_1");
        Assert.assertEquals((Object)map1, (Object)map2);
        map2.put("key_2", "value_2");
        Assert.assertNotEquals((Object)map1, (Object)map2);
    }
}

