/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.driver.core.DataType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.sql.type.SqlTypeName;

public class CqlToSqlTypeConversionRules {
    private static final CqlToSqlTypeConversionRules INSTANCE = new CqlToSqlTypeConversionRules();
    private final Map<DataType.Name, SqlTypeName> rules = ImmutableMap.builder().put((Object)DataType.Name.UUID, (Object)SqlTypeName.CHAR).put((Object)DataType.Name.TIMEUUID, (Object)SqlTypeName.CHAR).put((Object)DataType.Name.ASCII, (Object)SqlTypeName.VARCHAR).put((Object)DataType.Name.TEXT, (Object)SqlTypeName.VARCHAR).put((Object)DataType.Name.VARCHAR, (Object)SqlTypeName.VARCHAR).put((Object)DataType.Name.INT, (Object)SqlTypeName.INTEGER).put((Object)DataType.Name.VARINT, (Object)SqlTypeName.INTEGER).put((Object)DataType.Name.BIGINT, (Object)SqlTypeName.BIGINT).put((Object)DataType.Name.TINYINT, (Object)SqlTypeName.TINYINT).put((Object)DataType.Name.SMALLINT, (Object)SqlTypeName.SMALLINT).put((Object)DataType.Name.DOUBLE, (Object)SqlTypeName.DOUBLE).put((Object)DataType.Name.FLOAT, (Object)SqlTypeName.REAL).put((Object)DataType.Name.DECIMAL, (Object)SqlTypeName.DOUBLE).put((Object)DataType.Name.BLOB, (Object)SqlTypeName.VARBINARY).put((Object)DataType.Name.BOOLEAN, (Object)SqlTypeName.BOOLEAN).put((Object)DataType.Name.COUNTER, (Object)SqlTypeName.BIGINT).put((Object)DataType.Name.TIME, (Object)SqlTypeName.BIGINT).put((Object)DataType.Name.DATE, (Object)SqlTypeName.DATE).put((Object)DataType.Name.TIMESTAMP, (Object)SqlTypeName.TIMESTAMP).put((Object)DataType.Name.MAP, (Object)SqlTypeName.MAP).put((Object)DataType.Name.LIST, (Object)SqlTypeName.ARRAY).put((Object)DataType.Name.SET, (Object)SqlTypeName.MULTISET).put((Object)DataType.Name.TUPLE, (Object)SqlTypeName.STRUCTURED).build();

    public static CqlToSqlTypeConversionRules instance() {
        return INSTANCE;
    }

    public SqlTypeName lookup(DataType.Name name) {
        return this.rules.getOrDefault(name, SqlTypeName.ANY);
    }
}

