/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusteringOrder;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TupleType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.adapter.cassandra.CqlToSqlTypeConversionRules;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class CassandraSchema
extends AbstractSchema {
    final Session session;
    final String keyspace;
    private final SchemaPlus parentSchema;
    final String name;
    final Hook.Closeable hook;
    static final CodecRegistry CODEC_REGISTRY = CodecRegistry.DEFAULT_INSTANCE;
    static final CqlToSqlTypeConversionRules CQL_TO_SQL_TYPE = CqlToSqlTypeConversionRules.instance();
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final int DEFAULT_CASSANDRA_PORT = 9042;

    public CassandraSchema(String host, String keyspace, SchemaPlus parentSchema, String name) {
        this(host, 9042, keyspace, null, null, parentSchema, name);
    }

    public CassandraSchema(String host, int port, String keyspace, SchemaPlus parentSchema, String name) {
        this(host, port, keyspace, null, null, parentSchema, name);
    }

    public CassandraSchema(String host, String keyspace, String username, String password, SchemaPlus parentSchema, String name) {
        this(host, 9042, keyspace, username, password, parentSchema, name);
    }

    public CassandraSchema(String host, int port, String keyspace, String username, String password, SchemaPlus parentSchema, String name) {
        this.keyspace = keyspace;
        try {
            ArrayList<InetSocketAddress> contactPoints = new ArrayList<InetSocketAddress>(1);
            contactPoints.add(new InetSocketAddress(host, port));
            Cluster cluster = username != null && password != null ? Cluster.builder().addContactPointsWithPorts(contactPoints).withCredentials(username, password).build() : Cluster.builder().addContactPointsWithPorts(contactPoints).build();
            this.session = cluster.connect(keyspace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.parentSchema = parentSchema;
        this.name = name;
        this.hook = Hook.TRIMMED.add(node -> this.addMaterializedViews());
    }

    RelProtoDataType getRelDataType(String columnFamily, boolean view) {
        List columns = view ? this.getKeyspace().getMaterializedView("\"" + columnFamily + "\"").getColumns() : this.getKeyspace().getTable("\"" + columnFamily + "\"").getColumns();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        block6: for (ColumnMetadata column : columns) {
            SqlTypeName typeName = CQL_TO_SQL_TYPE.lookup(column.getType().getName());
            switch (typeName) {
                case ARRAY: {
                    SqlTypeName arrayInnerType = CQL_TO_SQL_TYPE.lookup(((DataType)column.getType().getTypeArguments().get(0)).getName());
                    fieldInfo.add(column.getName(), typeFactory.createArrayType(typeFactory.createSqlType(arrayInnerType), -1L)).nullable(true);
                    continue block6;
                }
                case MULTISET: {
                    SqlTypeName multiSetInnerType = CQL_TO_SQL_TYPE.lookup(((DataType)column.getType().getTypeArguments().get(0)).getName());
                    fieldInfo.add(column.getName(), typeFactory.createMultisetType(typeFactory.createSqlType(multiSetInnerType), -1L)).nullable(true);
                    continue block6;
                }
                case MAP: {
                    List types = column.getType().getTypeArguments();
                    SqlTypeName keyType = CQL_TO_SQL_TYPE.lookup(((DataType)types.get(0)).getName());
                    SqlTypeName valueType = CQL_TO_SQL_TYPE.lookup(((DataType)types.get(1)).getName());
                    fieldInfo.add(column.getName(), typeFactory.createMapType(typeFactory.createSqlType(keyType), typeFactory.createSqlType(valueType))).nullable(true);
                    continue block6;
                }
                case STRUCTURED: {
                    assert (DataType.Name.TUPLE == column.getType().getName());
                    List typeArgs = ((TupleType)column.getType()).getComponentTypes();
                    List typesList = IntStream.range(0, typeArgs.size()).mapToObj(arg_0 -> CassandraSchema.lambda$getRelDataType$1((RelDataTypeFactory)typeFactory, typeArgs, arg_0)).collect(Collectors.toList());
                    fieldInfo.add(column.getName(), typeFactory.createStructType(typesList)).nullable(true);
                    continue block6;
                }
            }
            fieldInfo.add(column.getName(), typeName).nullable(true);
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }

    Pair<List<String>, List<String>> getKeyFields(String columnFamily, boolean view) {
        Object table = view ? this.getKeyspace().getMaterializedView("\"" + columnFamily + "\"") : this.getKeyspace().getTable("\"" + columnFamily + "\"");
        List partitionKey = table.getPartitionKey();
        ArrayList<String> pKeyFields = new ArrayList<String>();
        for (ColumnMetadata column : partitionKey) {
            pKeyFields.add(column.getName());
        }
        List clusteringKey = table.getClusteringColumns();
        ArrayList<String> cKeyFields = new ArrayList<String>();
        for (ColumnMetadata column : clusteringKey) {
            cKeyFields.add(column.getName());
        }
        return Pair.of((Object)ImmutableList.copyOf(pKeyFields), (Object)ImmutableList.copyOf(cKeyFields));
    }

    public List<RelFieldCollation> getClusteringOrder(String columnFamily, boolean view) {
        Object table = view ? this.getKeyspace().getMaterializedView("\"" + columnFamily + "\"") : this.getKeyspace().getTable("\"" + columnFamily + "\"");
        List clusteringOrder = table.getClusteringOrder();
        ArrayList<RelFieldCollation> keyCollations = new ArrayList<RelFieldCollation>();
        int i = 0;
        for (ClusteringOrder order : clusteringOrder) {
            RelFieldCollation.Direction direction;
            switch (order) {
                case DESC: {
                    direction = RelFieldCollation.Direction.DESCENDING;
                    break;
                }
                default: {
                    direction = RelFieldCollation.Direction.ASCENDING;
                }
            }
            keyCollations.add(new RelFieldCollation(i, direction));
            ++i;
        }
        return keyCollations;
    }

    private void addMaterializedViews() {
        this.hook.close();
        for (MaterializedViewMetadata view : this.getKeyspace().getMaterializedViews()) {
            SqlSelect parsedQuery;
            String tableName = view.getBaseTable().getName();
            StringBuilder queryBuilder = new StringBuilder("SELECT ");
            ArrayList<String> columnNames = new ArrayList<String>();
            for (ColumnMetadata column : view.getColumns()) {
                columnNames.add("\"" + column.getName() + "\"");
            }
            queryBuilder.append(Util.toString(columnNames, (String)"", (String)", ", (String)""));
            queryBuilder.append(" FROM \"").append(tableName).append("\"");
            String whereQuery = "SELECT where_clause from system_schema.views WHERE keyspace_name='" + this.keyspace + "' AND view_name='" + view.getName() + "'";
            queryBuilder.append(" WHERE ").append(this.session.execute(whereQuery).one().getString(0));
            String query = queryBuilder.toString();
            SqlParser.ConfigBuilder configBuilder = SqlParser.configBuilder();
            configBuilder.setUnquotedCasing(Casing.UNCHANGED);
            try {
                parsedQuery = (SqlSelect)SqlParser.create((String)query, (SqlParser.Config)configBuilder.build()).parseQuery();
            }
            catch (SqlParseException e) {
                LOGGER.warn("Could not parse query {} for CQL view {}.{}", new Object[]{query, this.keyspace, view.getName()});
                continue;
            }
            StringWriter stringWriter = new StringWriter(query.length());
            PrintWriter printWriter = new PrintWriter(stringWriter);
            SqlPrettyWriter writer = new SqlPrettyWriter(CalciteSqlDialect.DEFAULT, true, printWriter);
            parsedQuery.unparse((SqlWriter)writer, 0, 0);
            query = stringWriter.toString();
            String viewName = "$" + this.getTableNames().size();
            SchemaPlus schema = this.parentSchema.getSubSchema(this.name);
            CalciteSchema calciteSchema = CalciteSchema.from((SchemaPlus)schema);
            List viewPath = calciteSchema.path(viewName);
            schema.add(viewName, (Function)MaterializedViewTable.create((CalciteSchema)calciteSchema, (String)query, null, (List)viewPath, (String)view.getName(), (boolean)true));
        }
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableMetadata table : this.getKeyspace().getTables()) {
            String tableName = table.getName();
            builder.put((Object)tableName, (Object)new CassandraTable(this, tableName));
            for (MaterializedViewMetadata view : table.getViews()) {
                String viewName = view.getName();
                builder.put((Object)viewName, (Object)new CassandraTable(this, viewName, true));
            }
        }
        return builder.build();
    }

    private KeyspaceMetadata getKeyspace() {
        return this.session.getCluster().getMetadata().getKeyspace(this.keyspace);
    }

    private static /* synthetic */ Pair lambda$getRelDataType$1(RelDataTypeFactory typeFactory, List typeArgs, int i) {
        return new Pair((Object)Integer.toString(i + 1), (Object)typeFactory.createSqlType(CQL_TO_SQL_TYPE.lookup(((DataType)typeArgs.get(i)).getName())));
    }
}

