/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.primitive;

import java.sql.Timestamp;
import org.apache.drill.exec.store.hive.writers.primitive.AbstractSingleValueWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HiveTimestampWriter
extends AbstractSingleValueWriter<PrimitiveObjectInspector, TimeStampWriter> {
    public HiveTimestampWriter(PrimitiveObjectInspector inspector, TimeStampWriter writer) {
        super(inspector, writer);
    }

    @Override
    public void write(Object value) {
        String timestampString = PrimitiveObjectInspectorUtils.getString((Object)value, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.inspector));
        long timestampMillis = new DateTime(Timestamp.valueOf(timestampString).getTime()).withZoneRetainFields(DateTimeZone.UTC).getMillis();
        ((TimeStampWriter)this.writer).writeTimeStamp(timestampMillis);
    }
}

