/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.BufferManager;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.writers.HiveValueWriter;
import org.apache.drill.exec.store.hive.writers.complex.HiveListWriter;
import org.apache.drill.exec.store.hive.writers.complex.HiveMapWriter;
import org.apache.drill.exec.store.hive.writers.complex.HiveStructWriter;
import org.apache.drill.exec.store.hive.writers.complex.HiveUnionWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveBinaryWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveBooleanWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveByteWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveCharWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveDateWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveDecimalWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveDoubleWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveFloatWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveIntWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveLongWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveShortWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveStringWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveTimestampWriter;
import org.apache.drill.exec.store.hive.writers.primitive.HiveVarCharWriter;
import org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import org.apache.drill.exec.vector.complex.impl.UnionVectorWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveValueWriterFactory {
    private static final Logger logger = LoggerFactory.getLogger(HiveValueWriterFactory.class);
    private final BufferManager bufferManager;
    private final SingleMapWriter rootWriter;

    public HiveValueWriterFactory(BufferManager bufferManager, SingleMapWriter rootWriter) {
        this.bufferManager = bufferManager;
        this.rootWriter = rootWriter;
    }

    public HiveValueWriter createHiveColumnValueWriter(String columnName, StructField fieldRef) {
        ObjectInspector objectInspector = fieldRef.getFieldObjectInspector();
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)objectInspector.getTypeName());
        return this.createHiveValueWriter(columnName, typeInfo, objectInspector, (BaseWriter)this.rootWriter);
    }

    private HiveValueWriter createHiveValueWriter(String columnName, TypeInfo typeInfo, ObjectInspector objectInspector, BaseWriter parentWriter) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return this.createPrimitiveHiveValueWriter(columnName, (PrimitiveTypeInfo)typeInfo, objectInspector, parentWriter);
            }
            case LIST: {
                TypeInfo elemTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
                ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
                ObjectInspector elementInspector = listInspector.getListElementObjectInspector();
                BaseWriter.ListWriter listWriter = HiveValueWriterFactory.extractWriter(columnName, parentWriter, BaseWriter.MapWriter::list, BaseWriter.ListWriter::list, UnionVectorWriter::list);
                HiveValueWriter elementValueWriter = this.createHiveValueWriter(null, elemTypeInfo, elementInspector, (BaseWriter)listWriter);
                return new HiveListWriter(listInspector, listWriter, elementValueWriter);
            }
            case STRUCT: {
                StructObjectInspector structInspector = (StructObjectInspector)objectInspector;
                StructField[] structFields = structInspector.getAllStructFieldRefs().toArray(new StructField[0]);
                BaseWriter.MapWriter structWriter = HiveValueWriterFactory.extractWriter(columnName, parentWriter, BaseWriter.MapWriter::map, BaseWriter.ListWriter::map, UnionVectorWriter::map);
                HiveValueWriter[] structFieldWriters = new HiveValueWriter[structFields.length];
                for (int fieldIdx = 0; fieldIdx < structFields.length; ++fieldIdx) {
                    StructField field = structFields[fieldIdx];
                    ObjectInspector fieldObjectInspector = field.getFieldObjectInspector();
                    TypeInfo fieldTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)fieldObjectInspector.getTypeName());
                    structFieldWriters[fieldIdx] = this.createHiveValueWriter(field.getFieldName(), fieldTypeInfo, fieldObjectInspector, (BaseWriter)structWriter);
                }
                return new HiveStructWriter(structInspector, structFields, structFieldWriters, structWriter);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                PrimitiveTypeInfo keyTypeInfo = (PrimitiveTypeInfo)mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                MapObjectInspector mapObjectInspector = (MapObjectInspector)objectInspector;
                ObjectInspector keyInspector = mapObjectInspector.getMapKeyObjectInspector();
                ObjectInspector valueInspector = mapObjectInspector.getMapValueObjectInspector();
                BaseWriter.DictWriter dictWriter = HiveValueWriterFactory.extractWriter(columnName, parentWriter, BaseWriter.MapWriter::dict, BaseWriter.ListWriter::dict, UnionVectorWriter::dict);
                HiveValueWriter mapKeyWriter = this.createPrimitiveHiveValueWriter("key", keyTypeInfo, keyInspector, (BaseWriter)dictWriter);
                HiveValueWriter mapValueWriter = this.createHiveValueWriter("value", valueTypeInfo, valueInspector, (BaseWriter)dictWriter);
                return new HiveMapWriter(mapObjectInspector, dictWriter, mapKeyWriter, mapValueWriter);
            }
            case UNION: {
                UnionObjectInspector unionObjectInspector = (UnionObjectInspector)objectInspector;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List unionFieldsTypeInfo = unionTypeInfo.getAllUnionObjectTypeInfos();
                List objectInspectors = unionObjectInspector.getObjectInspectors();
                UnionVectorWriter unionWriter = HiveValueWriterFactory.extractWriter(columnName, parentWriter, BaseWriter.MapWriter::union, BaseWriter.ListWriter::union, UnionVectorWriter::union);
                HiveValueWriter[] unionFieldWriters = new HiveValueWriter[unionFieldsTypeInfo.size()];
                for (int tag = 0; tag < unionFieldsTypeInfo.size(); ++tag) {
                    HiveValueWriter unionValueWriter;
                    ObjectInspector unionFieldInspector = (ObjectInspector)objectInspectors.get(tag);
                    TypeInfo unionFieldTypeInfo = (TypeInfo)unionFieldsTypeInfo.get(tag);
                    unionFieldWriters[tag] = unionValueWriter = this.createHiveValueWriter(null, unionFieldTypeInfo, unionFieldInspector, (BaseWriter)unionWriter);
                }
                return new HiveUnionWriter(unionFieldWriters, unionObjectInspector);
            }
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(typeInfo.getCategory().toString());
        return null;
    }

    private HiveValueWriter createPrimitiveHiveValueWriter(String name, PrimitiveTypeInfo typeInfo, ObjectInspector inspector, BaseWriter parentWriter) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BINARY: {
                VarBinaryWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::varBinary, BaseWriter.ListWriter::varBinary, UnionVectorWriter::varBinary);
                return new HiveBinaryWriter((BinaryObjectInspector)inspector, writer, this.bufferManager.getManagedBuffer());
            }
            case BOOLEAN: {
                BitWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::bit, BaseWriter.ListWriter::bit, UnionVectorWriter::bit);
                return new HiveBooleanWriter((BooleanObjectInspector)inspector, writer);
            }
            case BYTE: {
                IntWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::integer, BaseWriter.ListWriter::integer, UnionVectorWriter::integer);
                return new HiveByteWriter((ByteObjectInspector)inspector, writer);
            }
            case DOUBLE: {
                Float8Writer writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::float8, BaseWriter.ListWriter::float8, UnionVectorWriter::float8);
                return new HiveDoubleWriter((DoubleObjectInspector)inspector, writer);
            }
            case FLOAT: {
                Float4Writer writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::float4, BaseWriter.ListWriter::float4, UnionVectorWriter::float4);
                return new HiveFloatWriter((FloatObjectInspector)inspector, writer);
            }
            case INT: {
                IntWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::integer, BaseWriter.ListWriter::integer, UnionVectorWriter::integer);
                return new HiveIntWriter((IntObjectInspector)inspector, writer);
            }
            case LONG: {
                BigIntWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::bigInt, BaseWriter.ListWriter::bigInt, UnionVectorWriter::bigInt);
                return new HiveLongWriter((LongObjectInspector)inspector, writer);
            }
            case SHORT: {
                IntWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::integer, BaseWriter.ListWriter::integer, UnionVectorWriter::integer);
                return new HiveShortWriter((ShortObjectInspector)inspector, writer);
            }
            case STRING: {
                VarCharWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::varChar, BaseWriter.ListWriter::varChar, UnionVectorWriter::varChar);
                return new HiveStringWriter((StringObjectInspector)inspector, writer, this.bufferManager.getManagedBuffer());
            }
            case VARCHAR: {
                VarCharWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::varChar, BaseWriter.ListWriter::varChar, UnionVectorWriter::varChar);
                return new HiveVarCharWriter((HiveVarcharObjectInspector)inspector, writer, this.bufferManager.getManagedBuffer());
            }
            case TIMESTAMP: {
                TimeStampWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::timeStamp, BaseWriter.ListWriter::timeStamp, UnionVectorWriter::timeStamp);
                return new HiveTimestampWriter((PrimitiveObjectInspector)((TimestampObjectInspector)inspector), writer);
            }
            case DATE: {
                DateWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::date, BaseWriter.ListWriter::date, UnionVectorWriter::date);
                return new HiveDateWriter((PrimitiveObjectInspector)((DateObjectInspector)inspector), writer);
            }
            case CHAR: {
                VarCharWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, BaseWriter.MapWriter::varChar, BaseWriter.ListWriter::varChar, UnionVectorWriter::varChar);
                return new HiveCharWriter((HiveCharObjectInspector)inspector, writer, this.bufferManager.getManagedBuffer());
            }
            case DECIMAL: {
                DecimalTypeInfo decimalType = (DecimalTypeInfo)typeInfo;
                int scale = decimalType.getScale();
                int precision = decimalType.getPrecision();
                VarDecimalWriter writer = HiveValueWriterFactory.extractWriter(name, parentWriter, (mapWriter, key) -> mapWriter.varDecimal(key, precision, scale), listWriter -> listWriter.varDecimal(precision, scale), unionWriter -> unionWriter.varDecimal(precision, scale));
                return new HiveDecimalWriter((HiveDecimalObjectInspector)inspector, writer, scale);
            }
        }
        throw UserException.unsupportedError().message("Unsupported primitive data type '%s'", new Object[]{typeInfo.getPrimitiveCategory()}).build(logger);
    }

    private static <T> T extractWriter(String name, BaseWriter parentWriter, BiFunction<BaseWriter.MapWriter, String, T> fromMap, Function<BaseWriter.ListWriter, T> fromList, Function<UnionVectorWriter, T> fromUnion) {
        if (parentWriter instanceof BaseWriter.MapWriter && name != null) {
            return fromMap.apply((BaseWriter.MapWriter)parentWriter, name);
        }
        if (parentWriter instanceof UnionVectorWriter) {
            return fromUnion.apply((UnionVectorWriter)parentWriter);
        }
        if (parentWriter instanceof BaseWriter.ListWriter) {
            return fromList.apply((BaseWriter.ListWriter)parentWriter);
        }
        throw new IllegalStateException(String.format("Parent writer with type [%s] is unsupported", parentWriter.getClass()));
    }
}

