/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.fn.HiveFuncHolder;
import org.apache.drill.exec.expr.fn.PluggableFunctionRegistry;
import org.apache.drill.exec.expr.fn.impl.hive.ObjectInspectorHelper;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.sql.HiveUDFOperator;
import org.apache.drill.exec.planner.sql.HiveUDFOperatorWithoutInference;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveFunctionRegistry
implements PluggableFunctionRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HiveFunctionRegistry.class);
    private static final Map<String, String> FUNCTION_REPLACE_MAP = ImmutableMap.builder().put((Object)SqlStdOperatorTable.TRANSLATE.getName().toLowerCase(), (Object)OracleSqlOperatorTable.TRANSLATE3.getName().toLowerCase()).build();
    private final Multimap<String, Class<? extends GenericUDF>> methodsGenericUDF = ArrayListMultimap.create();
    private final Multimap<String, Class<? extends UDF>> methodsUDF = ArrayListMultimap.create();
    private final Set<Class<?>> nonDeterministicUDFs = new HashSet();

    public HiveFunctionRegistry(DrillConfig config) {
        ScanResult classpathScan = ClassPathScanner.fromPrescan((DrillConfig)config);
        Set genericUDFClasses = classpathScan.getImplementations(GenericUDF.class);
        for (Object clazz : genericUDFClasses) {
            this.register((Class)clazz, (Multimap)this.methodsGenericUDF);
        }
        Set udfClasses = classpathScan.getImplementations(UDF.class);
        for (Object clazz : udfClasses) {
            this.register((Class)clazz, (Multimap)this.methodsUDF);
        }
        if (logger.isTraceEnabled()) {
            StringBuilder allHiveFunctions = new StringBuilder();
            for (Object method : this.methodsGenericUDF.entries()) {
                allHiveFunctions.append(method.toString()).append("\n");
            }
            logger.trace("Registered Hive GenericUDFs: [\n{}]", (Object)allHiveFunctions);
            StringBuilder allUDFs = new StringBuilder();
            for (Map.Entry method : this.methodsUDF.entries()) {
                allUDFs.append(method.toString()).append("\n");
            }
            logger.trace("Registered Hive UDFs: [\n{}]", (Object)allUDFs);
            StringBuilder allNonDeterministic = new StringBuilder();
            for (Class<?> clz : this.nonDeterministicUDFs) {
                allNonDeterministic.append(clz.toString()).append("\n");
            }
            logger.trace("Registered Hive nonDeterministicUDFs: [\n{}]", (Object)allNonDeterministic);
        }
    }

    public void register(DrillOperatorTable operatorTable) {
        for (String name : Sets.union(this.methodsGenericUDF.asMap().keySet(), this.methodsUDF.asMap().keySet())) {
            operatorTable.addOperatorWithoutInference(name, (SqlOperator)new HiveUDFOperatorWithoutInference(name.toUpperCase()));
            operatorTable.addOperatorWithInference(name, (SqlOperator)new HiveUDFOperator(name.toUpperCase(), new HiveSqlReturnTypeInference()));
        }
    }

    private <I> void register(Class<? extends I> clazz, Multimap<String, Class<? extends I>> methods) {
        Description desc = clazz.getAnnotation(Description.class);
        Stream<String> namesStream = desc != null ? Stream.of(desc.name().split(",")).map(String::trim) : Stream.of(clazz).map(Class::getName).map(name -> name.replace('.', '_'));
        namesStream.map(String::toLowerCase).map(functionName -> FUNCTION_REPLACE_MAP.getOrDefault(functionName, (String)functionName)).forEach(name -> methods.put(name, (Object)clazz));
        UDFType type = clazz.getAnnotation(UDFType.class);
        if (type != null && !type.deterministic()) {
            this.nonDeterministicUDFs.add(clazz);
        }
    }

    public HiveFuncHolder getFunction(FunctionCall call) {
        HiveFuncHolder h = this.resolveFunction(call, false);
        if (h != null) {
            return h;
        }
        return this.resolveFunction(call, true);
    }

    private HiveFuncHolder resolveFunction(FunctionCall call, boolean varCharToStringReplacement) {
        HiveFuncHolder holder;
        TypeProtos.MajorType[] argTypes = new TypeProtos.MajorType[call.argCount()];
        ObjectInspector[] argOIs = new ObjectInspector[call.argCount()];
        for (int i = 0; i < call.argCount(); ++i) {
            try {
                argTypes[i] = call.arg(i).getMajorType();
                argOIs[i] = ObjectInspectorHelper.getDrillObjectInspector(argTypes[i].getMode(), argTypes[i].getMinorType(), varCharToStringReplacement);
                continue;
            }
            catch (Exception e) {
                logger.trace("Failed to find a hive function for given FunctionCall: '{}'", (Object)call.toString(), (Object)e);
                return null;
            }
        }
        String funcName = call.getName().toLowerCase();
        for (Class clazz : this.methodsGenericUDF.get((Object)funcName)) {
            holder = this.matchAndCreateGenericUDFHolder(clazz, argTypes, argOIs);
            if (holder == null) continue;
            return holder;
        }
        for (Class clazz : this.methodsUDF.get((Object)funcName)) {
            holder = this.matchAndCreateUDFHolder(call.getName(), clazz, argTypes, argOIs);
            if (holder == null) continue;
            return holder;
        }
        return null;
    }

    private HiveFuncHolder matchAndCreateGenericUDFHolder(Class<? extends GenericUDF> udfClazz, TypeProtos.MajorType[] argTypes, ObjectInspector[] argOIs) {
        try {
            GenericUDF udfInstance = udfClazz.newInstance();
            ObjectInspector returnOI = udfInstance.initialize(argOIs);
            return new HiveFuncHolder(udfClazz, argTypes, returnOI, Types.optional((TypeProtos.MinorType)ObjectInspectorHelper.getDrillType(returnOI)), this.nonDeterministicUDFs.contains(udfClazz));
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.debug("Failed to instantiate class", (Throwable)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private HiveFuncHolder matchAndCreateUDFHolder(String udfName, Class<? extends UDF> udfClazz, TypeProtos.MajorType[] argTypes, ObjectInspector[] argOIs) {
        try {
            GenericUDFBridge udfInstance = new GenericUDFBridge(udfName, false, udfClazz.getName());
            ObjectInspector returnOI = udfInstance.initialize(argOIs);
            return new HiveFuncHolder(udfName, udfClazz, argTypes, returnOI, Types.optional((TypeProtos.MinorType)ObjectInspectorHelper.getDrillType(returnOI)), this.nonDeterministicUDFs.contains(udfClazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public class HiveSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private HiveSqlReturnTypeInference() {
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            for (RelDataType type : opBinding.collectOperandTypes()) {
                TypeProtos.MinorType minorType = TypeInferenceUtils.getDrillTypeFromCalciteType((RelDataType)type);
                if (minorType != TypeProtos.MinorType.LATE) continue;
                return opBinding.getTypeFactory().createTypeWithNullability(opBinding.getTypeFactory().createSqlType(SqlTypeName.ANY), true);
            }
            FunctionCall functionCall = TypeInferenceUtils.convertSqlOperatorBindingToFunctionCall((SqlOperatorBinding)opBinding);
            HiveFuncHolder hiveFuncHolder = HiveFunctionRegistry.this.getFunction(functionCall);
            if (hiveFuncHolder == null) {
                StringBuilder operandTypes = new StringBuilder();
                for (int j = 0; j < opBinding.getOperandCount(); ++j) {
                    RelDataType operandType = opBinding.getOperandType(j);
                    operandTypes.append(operandType.getSqlTypeName());
                    if (operandType.isNullable()) {
                        operandTypes.append(":OPTIONAL");
                    }
                    if (j >= opBinding.getOperandCount() - 1) continue;
                    operandTypes.append(",");
                }
                throw UserException.functionError().message(String.format("%s does not support operand types (%s)", opBinding.getOperator().getName(), operandTypes), new Object[0]).build(logger);
            }
            return TypeInferenceUtils.convertToCalciteType((RelDataTypeFactory)opBinding.getTypeFactory(), (TypeProtos.MajorType)hiveFuncHolder.getReturnType(), (hiveFuncHolder.getReturnType().getMode() != TypeProtos.DataMode.REQUIRED ? 1 : 0) != 0);
        }
    }
}

